/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrtFileSystemImpl
extends JrtFileSystem {
    private final Map<String, ArchiveHandler> myHandlers = Collections.synchronizedMap(new THashMap(FileUtil.PATH_HASHING_STRATEGY));
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);
    private final DiskQueryRelay<VirtualFile, FileAttributes> myAttrGetter = new DiskQueryRelay(x$0 -> super.getAttributes(x$0));
    private final DiskQueryRelay<VirtualFile, String[]> myChildrenGetter = new DiskQueryRelay(x$0 -> super.list(x$0));

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        return (FileAttributes)this.myAttrGetter.accessDiskWithCheckCanceled((Object)file);
    }

    public String @NotNull [] list(@NotNull VirtualFile file) {
        return (String[])this.myChildrenGetter.accessDiskWithCheckCanceled((Object)file);
    }

    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int separatorIndex = path.indexOf("!/");
        return separatorIndex > 0 ? FileUtil.normalize((String)path.substring(0, separatorIndex)) + path.substring(separatorIndex) : null;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)"!/");
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + "!/";
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int separatorIndex = normalizedPath.indexOf("!/");
        return separatorIndex > 0 ? normalizedPath.substring(0, separatorIndex + "!/".length()) : "";
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        this.checkSubscription();
        String homePath = this.extractLocalPath(VfsUtilCore.getRootFile((VirtualFile)entryFile).getPath());
        return this.myHandlers.computeIfAbsent(homePath, key2 -> {
            JrtHandler handler = new JrtHandler((String)key2);
            ApplicationManager.getApplication().invokeLater(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(key2 + "/release"), ModalityState.defaultModalityState());
            return handler;
        });
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                HashSet<VirtualFile> toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    ArchiveHandler handler;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
                    String homePath = null;
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        VirtualFile file = ((VFileContentChangeEvent)vFileEvent).getFile();
                        if ("release".equals(file.getName())) {
                            homePath = file.getParent().getPath();
                        }
                    } else if (vFileEvent instanceof VFileDeleteEvent) {
                        homePath = ((VFileDeleteEvent)vFileEvent).getFile().getPath();
                    }
                    if (homePath == null || (handler = (ArchiveHandler)JrtFileSystemImpl.this.myHandlers.remove(homePath)) == null) continue;
                    handler.dispose();
                    VirtualFile root = JrtFileSystemImpl.this.findFileByPath(JrtFileSystemImpl.this.composeRootPath(homePath));
                    if (root == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = new HashSet<VirtualFile>();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        String path = local.getPath();
        return JdkUtil.isModularRuntime((String)path) && !JdkUtil.isExplodedModularRuntime((String)path);
    }

    public void release(@NotNull String localPath) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        ArchiveHandler handler = this.myHandlers.remove(localPath);
        if (handler == null) {
            throw new IllegalArgumentException(localPath + " not in " + this.myHandlers.keySet());
        }
        handler.dispose();
    }
}

