/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLibraryEditor
extends LibraryEditorBase {
    private String myLibraryName;
    private final MultiMap<OrderRootType, LightFilePointer> myRoots;
    private final Set<LightFilePointer> myExcludedRoots;
    private final MultiMap<OrderRootType, String> myJarDirectoryUrls = new MultiMap();
    private final MultiMap<OrderRootType, String> myJarDirectoryRecursiveUrls = new MultiMap();
    private LibraryType myType;
    private LibraryProperties myProperties;
    private boolean myKeepInvalidUrls = true;

    public NewLibraryEditor() {
        this(null, null);
    }

    public NewLibraryEditor(@Nullable LibraryType type2, @Nullable LibraryProperties properties) {
        this.myType = type2;
        this.myProperties = properties;
        this.myRoots = new MultiMap();
        this.myExcludedRoots = new LinkedHashSet<LightFilePointer>();
    }

    public void setKeepInvalidUrls(boolean keepInvalidUrls) {
        this.myKeepInvalidUrls = keepInvalidUrls;
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return this.myRoots.keySet();
    }

    @Nullable
    public LibraryType<?> getType() {
        return this.myType;
    }

    @Override
    public void setType(@NotNull LibraryType<?> type2) {
        this.myType = type2;
    }

    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myProperties = properties;
    }

    public String getName() {
        return this.myLibraryName;
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
        return NewLibraryEditor.pointersToUrls(this.myRoots.get((Object)rootType));
    }

    private static String[] pointersToUrls(Collection<? extends LightFilePointer> pointers) {
        ArrayList<String> urls = new ArrayList<String>(pointers.size());
        for (LightFilePointer lightFilePointer : pointers) {
            urls.add(lightFilePointer.getUrl());
        }
        return ArrayUtilRt.toStringArray(urls);
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType rootType) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (LightFilePointer pointer : this.myRoots.get((Object)rootType)) {
            String url;
            VirtualFile file = pointer.getFile();
            if (file == null) continue;
            if (file.isDirectory() && this.isJarDirectory(url = file.getUrl(), rootType)) {
                boolean recursive = this.myJarDirectoryRecursiveUrls.get((Object)rootType).contains(url);
                NewLibraryEditor.collectJarFiles(file, result, recursive);
                continue;
            }
            result.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public String @NotNull [] getExcludedRootUrls() {
        return NewLibraryEditor.pointersToUrls(this.myExcludedRoots);
    }

    public void setName(String name2) {
        this.myLibraryName = name2;
    }

    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(file));
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(url));
    }

    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive, @NotNull OrderRootType rootType) {
        this.addJarDirectory(file.getUrl(), recursive, rootType);
    }

    public void addExcludedRoot(@NotNull String url) {
        this.myExcludedRoots.add(new LightFilePointer(url));
    }

    public void removeExcludedRoot(@NotNull String url) {
        this.myExcludedRoots.remove(new LightFilePointer(url));
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        this.addRoot(url, rootType);
        (recursive ? this.myJarDirectoryRecursiveUrls : this.myJarDirectoryUrls).putValue((Object)rootType, (Object)url);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.myRoots.remove((Object)rootType, (Object)new LightFilePointer(url));
        this.myExcludedRoots.removeIf(pointer -> !this.isUnderRoots(pointer.getUrl()));
        this.myJarDirectoryUrls.remove((Object)rootType, (Object)url);
        this.myJarDirectoryRecursiveUrls.remove((Object)rootType, (Object)url);
    }

    private boolean isUnderRoots(@NotNull String url) {
        for (LightFilePointer pointer : this.myRoots.values()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)pointer.getUrl(), (String)url)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return true;
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        return this.myJarDirectoryUrls.get((Object)rootType).contains(url) || this.myJarDirectoryRecursiveUrls.get((Object)rootType).contains(url);
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType orderRootType) {
        Collection pointers = this.myRoots.get((Object)orderRootType);
        for (LightFilePointer pointer : pointers) {
            if (!pointer.getUrl().equals(url)) continue;
            return pointer.isValid();
        }
        return false;
    }

    public void applyTo(@NotNull LibraryEx.ModifiableModelEx model) {
        model.setProperties(this.myProperties);
        this.exportRoots(arg_0 -> ((LibraryEx.ModifiableModelEx)model).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEx.ModifiableModelEx)model).addJarDirectory(arg_0, arg_1, arg_2), arg_0 -> ((LibraryEx.ModifiableModelEx)model).addExcludedRoot(arg_0));
    }

    public void applyTo(@NotNull LibraryEditorBase editor) {
        editor.setProperties(this.myProperties);
        this.exportRoots(arg_0 -> ((LibraryEditorBase)editor).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEditorBase)editor).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEditorBase)editor).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEditorBase)editor).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEditorBase)editor).addJarDirectory(arg_0, arg_1, arg_2), arg_0 -> ((LibraryEditorBase)editor).addExcludedRoot(arg_0));
    }

    private void exportRoots(Function<? super OrderRootType, String[]> getUrls, BiPredicate<? super String, ? super OrderRootType> isValid, BiConsumer<? super String, ? super OrderRootType> removeRoot, BiConsumer<? super String, ? super OrderRootType> addRoot, TriConsumer<? super String, ? super Boolean, ? super OrderRootType> addJarDir, Consumer<? super String> addExcludedRoot) {
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            for (String url : getUrls.apply((OrderRootType)type2)) {
                if (this.myKeepInvalidUrls && !isValid.test(url, (OrderRootType)type2)) continue;
                removeRoot.accept(url, (OrderRootType)type2);
            }
        }
        for (OrderRootType type3 : this.myRoots.keySet()) {
            for (LightFilePointer pointer : this.myRoots.get((Object)type3)) {
                if (this.isJarDirectory(pointer.getUrl(), type3)) continue;
                addRoot.accept(pointer.getUrl(), (OrderRootType)type3);
            }
        }
        for (Map.Entry entry : this.myJarDirectoryUrls.entrySet()) {
            OrderRootType type4 = (OrderRootType)entry.getKey();
            for (String url : (Collection)entry.getValue()) {
                addJarDir.accept(url, (Boolean)false, (OrderRootType)type4);
            }
        }
        for (Map.Entry entry : this.myJarDirectoryRecursiveUrls.entrySet()) {
            OrderRootType type5 = (OrderRootType)entry.getKey();
            for (String url : (Collection)entry.getValue()) {
                addJarDir.accept(url, (Boolean)true, (OrderRootType)type5);
            }
        }
        for (LightFilePointer root : this.myExcludedRoots) {
            addExcludedRoot.accept(root.getUrl());
        }
    }

    private static void collectJarFiles(@NotNull VirtualFile dir, final @NotNull List<? super VirtualFile> container, boolean recursively) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, recursively ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(@NotNull VirtualFile file) {
                VirtualFile jarRoot;
                if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file.getPath() + "!/")) != null) {
                    container.add(jarRoot);
                    return false;
                }
                return true;
            }
        });
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, P> {
        public void accept(T var1, U var2, P var3);
    }
}

