/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateModuleLibraryChooser
implements ClasspathElementChooser<Library> {
    private final JComponent myParentComponent;
    private final Module myModule;
    private final LibraryTable.ModifiableModel myModuleLibrariesModel;
    @Nullable
    private final Function<? super LibraryType, ? extends LibraryProperties> myDefaultPropertiesFactory;
    private final HashMap<LibraryRootsComponentDescriptor, LibraryType> myLibraryTypes;
    private final DefaultLibraryRootsComponentDescriptor myDefaultDescriptor;

    public CreateModuleLibraryChooser(ClasspathPanel classpathPanel, LibraryTable.ModifiableModel moduleLibraryModel) {
        this(LibraryEditingUtil.getSuitableTypes(classpathPanel), classpathPanel.getComponent(), classpathPanel.getRootModel().getModule(), moduleLibraryModel, null);
    }

    public CreateModuleLibraryChooser(List<? extends LibraryType> libraryTypes, JComponent parentComponent, Module module, LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType, ? extends LibraryProperties> defaultPropertiesFactory) {
        this.myParentComponent = parentComponent;
        this.myModule = module;
        this.myModuleLibrariesModel = moduleLibrariesModel;
        this.myDefaultPropertiesFactory = defaultPropertiesFactory;
        this.myLibraryTypes = new HashMap();
        this.myDefaultDescriptor = new DefaultLibraryRootsComponentDescriptor();
        for (LibraryType libraryType : libraryTypes) {
            boolean acceptsClasses;
            LibraryRootsComponentDescriptor descriptor = null;
            if (libraryType != null) {
                descriptor = libraryType.createLibraryRootsComponentDescriptor();
            }
            if (descriptor == null) {
                descriptor = this.myDefaultDescriptor;
            }
            if (!(acceptsClasses = descriptor.getRootDetectors().stream().anyMatch(detector -> detector.getRootType().equals((Object)OrderRootType.CLASSES))) || this.myLibraryTypes.containsKey(descriptor)) continue;
            this.myLibraryTypes.put(descriptor, libraryType);
        }
    }

    private static Library createLibraryFromRoots(@NotNull List<? extends OrderRoot> roots, @Nullable LibraryType libraryType, @NotNull LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType, ? extends LibraryProperties> defaultPropertiesFactory) {
        PersistentLibraryKind kind2 = libraryType == null ? null : libraryType.getKind();
        Library library = moduleLibrariesModel.createLibrary(null, kind2);
        LibraryEx.ModifiableModelEx libModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        if (defaultPropertiesFactory != null) {
            libModel.setProperties((LibraryProperties)defaultPropertiesFactory.fun((Object)libraryType));
        }
        for (OrderRoot orderRoot : roots) {
            if (orderRoot.isJarDirectory()) {
                libModel.addJarDirectory(orderRoot.getFile(), false, orderRoot.getType());
                continue;
            }
            libModel.addRoot(orderRoot.getFile(), orderRoot.getType());
        }
        libModel.commit();
        return library;
    }

    private static List<OrderRoot> filterAlreadyAdded(List<? extends OrderRoot> roots, LibraryTable.ModifiableModel moduleLibrariesModel) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        Library[] libraries2 = moduleLibrariesModel.getLibraries();
        for (OrderRoot orderRoot : roots) {
            if (!Arrays.stream(libraries2).noneMatch(library -> ArrayUtil.contains((Object)root.getFile(), (Object[])library.getFiles(root.getType())))) continue;
            result.add(orderRoot);
        }
        return result;
    }

    @Override
    @NotNull
    public List<Library> chooseElements() {
        DefaultLibraryRootsComponentDescriptor rootsComponentDescriptor;
        final ArrayList<Pair> descriptors = new ArrayList<Pair>();
        for (LibraryRootsComponentDescriptor componentDescriptor : this.myLibraryTypes.keySet()) {
            descriptors.add(Pair.create((Object)componentDescriptor, (Object)componentDescriptor.createAttachFilesChooserDescriptor(null)));
        }
        FileChooserDescriptor chooserDescriptor = descriptors.size() == 1 ? (FileChooserDescriptor)((Pair)descriptors.get(0)).getSecond() : new FileChooserDescriptor(true, true, true, false, true, false){

            public boolean isFileSelectable(VirtualFile file) {
                for (Pair pair2 : descriptors) {
                    if (!((FileChooserDescriptor)pair2.getSecond()).isFileSelectable(file)) continue;
                    return true;
                }
                return false;
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                for (Pair pair2 : descriptors) {
                    if (!((FileChooserDescriptor)pair2.getSecond()).isFileVisible(file, showHiddenFiles)) continue;
                    return true;
                }
                return false;
            }
        };
        chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        Project project = this.myModule.getProject();
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)this.myParentComponent, (Project)project, (VirtualFile)project.getBaseDir());
        if (files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> suitableDescriptors = new ArrayList<Object>();
        for (Pair pair2 : descriptors) {
            if (!CreateModuleLibraryChooser.acceptAll((FileChooserDescriptor)pair2.getSecond(), files)) continue;
            suitableDescriptors.add(pair2.getFirst());
        }
        LibraryType libraryType = null;
        if (suitableDescriptors.size() == 1) {
            rootsComponentDescriptor = (LibraryRootsComponentDescriptor)suitableDescriptors.get(0);
            libraryType = this.myLibraryTypes.get((Object)rootsComponentDescriptor);
        } else {
            rootsComponentDescriptor = this.myDefaultDescriptor;
        }
        List chosenRoots = RootDetectionUtil.detectRoots(Arrays.asList(files), (Component)this.myParentComponent, (Project)project, (LibraryRootsComponentDescriptor)rootsComponentDescriptor);
        return CreateModuleLibraryChooser.createLibrariesFromRoots(chosenRoots, libraryType, this.myModuleLibrariesModel, this.myDefaultPropertiesFactory);
    }

    @NotNull
    public static List<Library> createLibrariesFromRoots(List<? extends OrderRoot> chosenRoots, LibraryTable.ModifiableModel moduleLibrariesModel) {
        return CreateModuleLibraryChooser.createLibrariesFromRoots(chosenRoots, null, moduleLibrariesModel, null);
    }

    @NotNull
    private static List<Library> createLibrariesFromRoots(@NotNull List<? extends OrderRoot> chosenRoots, @Nullable LibraryType libraryType, @NotNull LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType, ? extends LibraryProperties> defaultPropertiesFactory) {
        List<OrderRoot> roots = CreateModuleLibraryChooser.filterAlreadyAdded(chosenRoots, moduleLibrariesModel);
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Library> addedLibraries = new ArrayList<Library>();
        Map byFile = roots.stream().collect(Collectors.groupingBy(OrderRoot::getFile, LinkedHashMap::new, Collectors.toList()));
        Predicate<List> containsClasses = it -> it.stream().anyMatch(root -> root.getType().equals((Object)OrderRootType.CLASSES));
        if (byFile.values().stream().allMatch(containsClasses)) {
            for (List rootsForFile : byFile.values()) {
                addedLibraries.add(CreateModuleLibraryChooser.createLibraryFromRoots(rootsForFile, libraryType, moduleLibrariesModel, defaultPropertiesFactory));
            }
        } else {
            addedLibraries.add(CreateModuleLibraryChooser.createLibraryFromRoots(roots, libraryType, moduleLibrariesModel, defaultPropertiesFactory));
        }
        return addedLibraries;
    }

    private static boolean acceptAll(FileChooserDescriptor descriptor, VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (descriptor.isFileSelectable(file) && descriptor.isFileVisible(file, true)) continue;
            return false;
        }
        return true;
    }
}

