/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.util.Disposer;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaModifiableModelsProvider
implements ModifiableModelsProvider {
    @Nullable
    public ModifiableRootModel getModuleModifiableModel(@NotNull Module module) {
        ModuleEditor moduleEditor;
        Project project = module.getProject();
        ModulesConfigurator configurator = IdeaModifiableModelsProvider.getModulesConfigurator(project);
        if (configurator != null && !configurator.isModuleModelCommitted() && (moduleEditor = configurator.getModuleEditor(module)) != null) {
            return moduleEditor.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)module).getModifiableModel();
    }

    @Nullable
    private static ModulesConfigurator getModulesConfigurator(@NotNull Project project) {
        StructureConfigurableContext context = IdeaModifiableModelsProvider.getProjectStructureContext(project);
        return context != null ? context.getModulesConfigurator() : null;
    }

    public void commitModuleModifiableModel(@NotNull ModifiableRootModel model) {
        if (!(model instanceof Proxy)) {
            model.commit();
        }
    }

    public void disposeModuleModifiableModel(@NotNull ModifiableRootModel model) {
        if (!(model instanceof Proxy)) {
            model.dispose();
        }
    }

    @NotNull
    public ModifiableFacetModel getFacetModifiableModel(@NotNull Module module) {
        ModulesConfigurator configurator = IdeaModifiableModelsProvider.getModulesConfigurator(module.getProject());
        if (configurator != null) {
            return configurator.getFacetsConfigurator().getOrCreateModifiableModel(module);
        }
        return FacetManager.getInstance((Module)module).createModifiableModel();
    }

    public void commitFacetModifiableModel(@NotNull Module module, @NotNull ModifiableFacetModel model) {
        ModulesConfigurator configurator = IdeaModifiableModelsProvider.getModulesConfigurator(module.getProject());
        if (configurator == null || !(configurator.getFacetsConfigurator().getFacetModel(module) instanceof ModifiableFacetModel)) {
            model.commit();
        }
    }

    @NotNull
    public LibraryTable.ModifiableModel getLibraryTableModifiableModel() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            LibraryTable.ModifiableModel modifiableModel;
            if (!project.isInitialized()) continue;
            StructureConfigurableContext context = IdeaModifiableModelsProvider.getProjectStructureContext(project);
            StructureLibraryTableModifiableModelProvider provider = context != null ? context.createModifiableModelProvider("application") : null;
            LibraryTable.ModifiableModel modifiableModel2 = modifiableModel = provider != null ? provider.getModifiableModel() : null;
            if (modifiableModel == null) continue;
            return modifiableModel;
        }
        return LibraryTablesRegistrar.getInstance().getLibraryTable().getModifiableModel();
    }

    public LibraryTable.ModifiableModel getLibraryTableModifiableModel(@NotNull Project project) {
        StructureConfigurableContext context = IdeaModifiableModelsProvider.getProjectStructureContext(project);
        if (context != null) {
            StructureLibraryTableModifiableModelProvider provider = context.createModifiableModelProvider("project");
            return provider.getModifiableModel();
        }
        return LibraryTablesRegistrar.getInstance().getLibraryTable(project).getModifiableModel();
    }

    public void disposeLibraryTableModifiableModel(@NotNull LibraryTable.ModifiableModel model) {
        if (!(model instanceof LibrariesModifiableModel)) {
            Disposer.dispose((Disposable)model);
        }
    }

    @Nullable
    private static StructureConfigurableContext getProjectStructureContext(@NotNull Project project) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        ProjectStructureConfigurable structureConfigurable = ProjectStructureConfigurable.getInstance(project);
        return structureConfigurable.isUiInitialized() ? structureConfigurable.getContext() : null;
    }
}

