/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.DefaultJdkConfigurator;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public final class JavaAwareProjectJdkTableImpl
extends ProjectJdkTableImpl {
    private static final String DEFAULT_JDK_CONFIGURED = "defaultJdkConfigured";
    private Sdk myInternalJdk;

    public static JavaAwareProjectJdkTableImpl getInstanceEx() {
        return (JavaAwareProjectJdkTableImpl)((Object)ServiceManager.getService(ProjectJdkTable.class));
    }

    public void preconfigure() {
        String suggestedName;
        String homePath;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (propertiesComponent.getBoolean(DEFAULT_JDK_CONFIGURED, false) || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = this.getSdksOfType((SdkTypeId)javaSdk);
        if (jdks.isEmpty() && (homePath = ((DefaultJdkConfigurator)ServiceManager.getService(DefaultJdkConfigurator.class)).guessJavaHome()) != null && javaSdk.isValidSdkHome(homePath) && (suggestedName = JdkUtil.suggestJdkName((String)javaSdk.getVersionString(homePath))) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> this.addJdk(javaSdk.createJdk(suggestedName, homePath, false)));
        }
        propertiesComponent.setValue(DEFAULT_JDK_CONFIGURED, true);
    }

    @Deprecated
    @NotNull
    public Sdk getInternalJdk() {
        if (this.myInternalJdk == null) {
            File javaHomeParent;
            File javaHome = new File(SystemProperties.getJavaHome());
            if (JdkUtil.checkForJre((File)javaHome) && !JdkUtil.checkForJdk((File)javaHome) && (javaHomeParent = javaHome.getParentFile()) != null && JdkUtil.checkForJre((File)javaHomeParent) && JdkUtil.checkForJdk((File)javaHomeParent)) {
                javaHome = javaHomeParent;
            }
            String versionName = JdkVersionDetector.formatVersionString((JavaVersion)JavaVersion.current());
            this.myInternalJdk = JavaSdk.getInstance().createJdk(versionName, javaHome.getAbsolutePath(), !JdkUtil.checkForJdk((File)javaHome));
        }
        return this.myInternalJdk;
    }

    public void removeJdk(@NotNull Sdk jdk) {
        super.removeJdk(jdk);
        if (jdk.equals(this.myInternalJdk)) {
            this.myInternalJdk = null;
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        return JavaSdk.getInstance();
    }

    public void loadState(@NotNull Element element) {
        this.myInternalJdk = null;
        super.loadState(element);
    }

    public static void removeInternalJdkInTests() {
        WriteAction.run(() -> {
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            if (table.myInternalJdk != null) {
                table.removeJdk(table.myInternalJdk);
            }
        });
    }
}

