/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.lexer;

import com.intellij.lang.java.lexer._JavaDocLexer;
import com.intellij.lexer.DocCommentTokenTypes;
import com.intellij.lexer.JavaDocTokenTypes;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaDocLexer
extends MergingLexerAdapter {
    public JavaDocLexer(@NotNull LanguageLevel level) {
        this(JavaDocTokenTypes.INSTANCE, level.isAtLeast(LanguageLevel.JDK_1_5));
    }

    private JavaDocLexer(DocCommentTokenTypes tokenTypes, boolean isJdk15Enabled) {
        super((Lexer)new AsteriskStripperLexer(new _JavaDocLexer(isJdk15Enabled, tokenTypes), tokenTypes), tokenTypes.spaceCommentsTokenSet());
    }

    private static class AsteriskStripperLexer
    extends LexerBase {
        private final _JavaDocLexer myFlex;
        private final DocCommentTokenTypes myTokenTypes;
        private CharSequence myBuffer;
        private int myBufferIndex;
        private int myBufferEndOffset;
        private int myTokenEndOffset;
        private int myState;
        private IElementType myTokenType;
        private boolean myAfterLineBreak;
        private boolean myInLeadingSpace;

        AsteriskStripperLexer(_JavaDocLexer flex, DocCommentTokenTypes tokenTypes) {
            this.myFlex = flex;
            this.myTokenTypes = tokenTypes;
        }

        public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            this.myBuffer = buffer;
            this.myBufferIndex = startOffset;
            this.myBufferEndOffset = endOffset;
            this.myTokenType = null;
            this.myTokenEndOffset = startOffset;
            this.myFlex.reset(this.myBuffer, startOffset, endOffset, initialState);
        }

        public int getState() {
            return this.myState;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            return this.myBuffer;
        }

        public int getBufferEnd() {
            return this.myBufferEndOffset;
        }

        public final IElementType getTokenType() {
            this.locateToken();
            return this.myTokenType;
        }

        public final int getTokenStart() {
            this.locateToken();
            return this.myBufferIndex;
        }

        public final int getTokenEnd() {
            this.locateToken();
            return this.myTokenEndOffset;
        }

        public final void advance() {
            this.locateToken();
            this.myTokenType = null;
        }

        protected final void locateToken() {
            if (this.myTokenType != null) {
                return;
            }
            this._locateToken();
            if (this.myTokenType == this.myTokenTypes.space()) {
                this.myAfterLineBreak = CharArrayUtil.containLineBreaks((CharSequence)this.myBuffer, (int)this.getTokenStart(), (int)this.getTokenEnd());
            }
        }

        private void _locateToken() {
            if (this.myTokenEndOffset == this.myBufferEndOffset) {
                this.myTokenType = null;
                this.myBufferIndex = this.myBufferEndOffset;
                return;
            }
            this.myBufferIndex = this.myTokenEndOffset;
            if (this.myAfterLineBreak) {
                this.myAfterLineBreak = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && this.myBuffer.charAt(this.myTokenEndOffset) == '*' && (this.myTokenEndOffset + 1 >= this.myBufferEndOffset || this.myBuffer.charAt(this.myTokenEndOffset + 1) != '/')) {
                    ++this.myTokenEndOffset;
                }
                this.myInLeadingSpace = true;
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = this.myTokenTypes.commentLeadingAsterisks();
                    return;
                }
            }
            if (this.myInLeadingSpace) {
                this.myInLeadingSpace = false;
                boolean lf = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && Character.isWhitespace(this.myBuffer.charAt(this.myTokenEndOffset))) {
                    if (this.myBuffer.charAt(this.myTokenEndOffset) == '\n') {
                        lf = true;
                    }
                    ++this.myTokenEndOffset;
                }
                int state = this.myFlex.yystate();
                if (state == 4 || this.myTokenEndOffset < this.myBufferEndOffset && (this.myBuffer.charAt(this.myTokenEndOffset) == '@' || this.myBuffer.charAt(this.myTokenEndOffset) == '{' || this.myBuffer.charAt(this.myTokenEndOffset) == '\"' || this.myBuffer.charAt(this.myTokenEndOffset) == '<')) {
                    this.myFlex.yybegin(2);
                }
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = lf || state == 8 || state == 6 || state == 16 || state == 12 ? this.myTokenTypes.space() : this.myTokenTypes.commentData();
                    return;
                }
            }
            this.flexLocateToken();
        }

        private void flexLocateToken() {
            try {
                this.myState = this.myFlex.yystate();
                this.myFlex.goTo(this.myBufferIndex);
                this.myTokenType = this.myFlex.advance();
                this.myTokenEndOffset = this.myFlex.getTokenEnd();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

