/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.jarFinder.MavenCentralSourceSearcher;
import com.intellij.jarFinder.SonatypeSourceSearcher;
import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternetAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(InternetAttachSourceProvider.class);
    private static final Pattern ARTIFACT_IDENTIFIER = Pattern.compile("[A-Za-z0-9\\.\\-_]+");

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final @Nullable PsiFile psiFile) {
        final VirtualFile jar = InternetAttachSourceProvider.getJarByPsiFile(psiFile);
        if (jar == null) {
            return Collections.emptyList();
        }
        final String jarName = jar.getNameWithoutExtension();
        int index = jarName.lastIndexOf(45);
        if (index == -1) {
            return Collections.emptyList();
        }
        final String version = jarName.substring(index + 1);
        final String artifactId = jarName.substring(0, index);
        if (!ARTIFACT_IDENTIFIER.matcher(version).matches() || !ARTIFACT_IDENTIFIER.matcher(artifactId).matches()) {
            return Collections.emptyList();
        }
        final HashSet libraries2 = new HashSet();
        for (LibraryOrderEntry libraryOrderEntry : orderEntries) {
            ContainerUtil.addIfNotNull(libraries2, (Object)libraryOrderEntry.getLibrary());
        }
        if (libraries2.isEmpty()) {
            return Collections.emptyList();
        }
        final String sourceFileName = jarName + "-sources.jar";
        for (Library library : libraries2) {
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                if (!file.getPath().contains(sourceFileName) || !InternetAttachSourceProvider.isRootInExistingFile(file)) continue;
                return Collections.emptyList();
            }
        }
        final File file = InternetAttachSourceProvider.getLibrarySourceDir();
        final File sourceFile = new File(file, sourceFileName);
        if (sourceFile.exists()) {
            return Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction(){

                public String getName() {
                    return "Attach downloaded source";
                }

                public String getBusyText() {
                    return this.getName();
                }

                public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
                    InternetAttachSourceProvider.attachSourceJar(sourceFile, libraries2);
                    return ActionCallback.DONE;
                }
            });
        }
        return Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction(){

            public String getName() {
                return "Download...";
            }

            public String getBusyText() {
                return "Searching...";
            }

            public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
                Task.Modal task = new Task.Modal(psiFile.getProject(), JavaUiBundle.message("progress.title.searching.source", new Object[0]), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        SourceSearcher[] searchers;
                        String artifactUrl = null;
                        for (SourceSearcher searcher : searchers = new SourceSearcher[]{new MavenCentralSourceSearcher(), new SonatypeSourceSearcher()}) {
                            try {
                                artifactUrl = searcher.findSourceJar(indicator, artifactId, version, jar);
                            }
                            catch (SourceSearchException e) {
                                LOG.warn((Throwable)e);
                                this.showMessage("Downloading failed", e.getMessage(), NotificationType.ERROR);
                                continue;
                            }
                            if (artifactUrl != null) break;
                        }
                        if (artifactUrl == null) {
                            this.showMessage("Sources not found", "Sources for '" + jarName + ".jar' not found", NotificationType.WARNING);
                            return;
                        }
                        if (!file.isDirectory() && !file.mkdirs()) {
                            this.showMessage("Downloading failed", "Failed to create directory to store sources: " + file, NotificationType.ERROR);
                            return;
                        }
                        try {
                            File tmpDownload = FileUtil.createTempFile((File)file, (String)"download.", (String)".tmp", (boolean)false, (boolean)false);
                            HttpRequests.request((String)artifactUrl).saveToFile(tmpDownload, indicator);
                            if (!sourceFile.exists() && !tmpDownload.renameTo(sourceFile)) {
                                LOG.warn("Failed to rename file " + tmpDownload + " to " + sourceFileName);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                            this.showMessage("Downloading failed", "Connection problem. See log for more details.", NotificationType.ERROR);
                        }
                    }

                    public void onSuccess() {
                        InternetAttachSourceProvider.attachSourceJar(sourceFile, libraries2);
                    }

                    private void showMessage(String title, String message2, NotificationType notificationType) {
                        new Notification("Source searcher", title, message2, notificationType).notify(this.getProject());
                    }
                };
                task.queue();
                return ActionCallback.DONE;
            }
        });
    }

    private static boolean isRootInExistingFile(VirtualFile root) {
        VirtualFile jar;
        return !(root.getFileSystem() instanceof JarFileSystem) || (jar = JarFileSystem.getInstance().getVirtualFileForJar(root)) != null && VfsUtilCore.virtualToIoFile((VirtualFile)jar).exists();
    }

    public static void attachSourceJar(@NotNull File sourceJar, @NotNull Collection<? extends Library> libraries2) {
        VirtualFile srcFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(sourceJar);
        if (srcFile == null) {
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
        if (jarRoot == null) {
            return;
        }
        VirtualFile[] roots = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(null, new VirtualFile[]{jarRoot});
        if (roots.length == 0) {
            roots = new VirtualFile[]{jarRoot};
        }
        InternetAttachSourceProvider.doAttachSourceJars(libraries2, roots);
    }

    private static void doAttachSourceJars(@NotNull Collection<? extends Library> libraries2, VirtualFile[] roots) {
        WriteAction.run(() -> {
            for (Library library : libraries2) {
                Library.ModifiableModel model = library.getModifiableModel();
                HashSet alreadyExistingFiles = ContainerUtil.newHashSet((Object[])model.getFiles(OrderRootType.SOURCES));
                for (VirtualFile root : roots) {
                    if (alreadyExistingFiles.contains(root)) continue;
                    model.addRoot(root, OrderRootType.SOURCES);
                }
                model.commit();
            }
        });
    }

    public static File getLibrarySourceDir() {
        String path = System.getProperty("idea.library.source.dir");
        return path != null ? new File(path) : new File(SystemProperties.getUserHome(), ".ideaLibSources");
    }
}

