/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.framework.library.impl.FrameworkLibraryVersionImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelAdapter;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.newProjectWizard.FrameworkVersionComponent;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportOptionsComponent {
    private final JPanel myMainPanel;
    private final FrameworkSupportModelBase myModel;
    private final FrameworkVersionComponent myFrameworkVersionComponent;
    private LibraryCompositionSettings myLibraryCompositionSettings;
    private LibraryOptionsPanel myLibraryOptionsPanel;
    private final FrameworkSupportInModuleConfigurable myConfigurable;
    private final JPanel myLibraryOptionsPanelWrapper;

    public FrameworkSupportOptionsComponent(FrameworkSupportModelBase model, LibrariesContainer container, Disposable parentDisposable, final FrameworkSupportInModuleProvider provider, FrameworkSupportInModuleConfigurable configurable) {
        this.myModel = model;
        this.myConfigurable = configurable;
        VerticalFlowLayout layout = new VerticalFlowLayout(0, 0, 3, true, false);
        layout.setVerticalFill(true);
        this.myMainPanel = new JPanel((LayoutManager)layout);
        this.myModel.registerOptionsComponent(provider, this);
        List versions = provider.getFrameworkType().getVersions();
        if (!versions.isEmpty()) {
            this.myFrameworkVersionComponent = new FrameworkVersionComponent(model, provider.getFrameworkType().getId(), versions, "Versions:");
            this.myMainPanel.add(this.myFrameworkVersionComponent.getMainPanel());
        } else {
            this.myFrameworkVersionComponent = null;
        }
        JComponent component = this.myConfigurable.createComponent();
        if (component != null) {
            this.myMainPanel.add(component);
        }
        boolean addSeparator = component != null || this.myFrameworkVersionComponent != null;
        this.myLibraryOptionsPanelWrapper = new JPanel(new BorderLayout());
        this.myMainPanel.add(this.myLibraryOptionsPanelWrapper);
        if (this.myConfigurable instanceof OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper) {
            ((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)this.myConfigurable).getConfigurable().addListener(new FrameworkSupportConfigurableListener(){

                public void frameworkVersionChanged() {
                    FrameworkSupportOptionsComponent.this.updateLibrariesPanel();
                }
            });
        }
        model.addFrameworkListener((FrameworkSupportModelListener)new FrameworkSupportModelAdapter(){

            public void wizardStepUpdated() {
                FrameworkSupportOptionsComponent.this.updateLibrariesPanel();
            }
        }, parentDisposable);
        CustomLibraryDescription description = this.myConfigurable.createLibraryDescription();
        if (description != null) {
            this.myLibraryOptionsPanel = new LibraryOptionsPanel(description, () -> this.myModel.getBaseDirectoryForLibrariesPath(), this.createLibraryVersionFilter(), container, !this.myConfigurable.isOnlyLibraryAdded()){

                @Override
                protected void onVersionChanged(@Nullable String version) {
                    if (FrameworkSupportOptionsComponent.this.myFrameworkVersionComponent == null) {
                        FrameworkSupportOptionsComponent.this.myModel.setSelectedLibraryVersion(provider.getId(), version);
                    }
                }
            };
            this.myLibraryOptionsPanel.setLibraryProvider(this.myModel.getLibraryProvider());
            Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myLibraryOptionsPanel);
            if (addSeparator) {
                TitledSeparator separator1 = SeparatorFactory.createSeparator((String)"Libraries", null);
                separator1.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
                this.myLibraryOptionsPanelWrapper.add("North", (Component)separator1);
            }
            this.myLibraryOptionsPanelWrapper.add("Center", this.myLibraryOptionsPanel.getMainPanel());
            this.myLibraryOptionsPanelWrapper.setVisible(this.myConfigurable.isVisible());
        }
    }

    public void updateLibrariesPanel() {
        if (this.myLibraryOptionsPanel != null) {
            this.myLibraryOptionsPanel.setVersionFilter(this.createLibraryVersionFilter());
            this.myLibraryOptionsPanel.setLibraryProvider(this.myModel.getLibraryProvider());
            this.myLibraryOptionsPanelWrapper.setVisible(this.myConfigurable.isVisible());
        }
    }

    public void updateVersionsComponent() {
        if (this.myFrameworkVersionComponent != null) {
            this.myFrameworkVersionComponent.updateVersionsList();
        }
    }

    private FrameworkLibraryVersionFilter createLibraryVersionFilter() {
        return new FrameworkLibraryVersionFilter(){

            public boolean isAccepted(@NotNull FrameworkLibraryVersion version) {
                return FrameworkSupportOptionsComponent.this.myConfigurable.getLibraryVersionFilter().isAccepted(version) && ((FrameworkLibraryVersionImpl)version).getAvailabilityCondition().isAvailableFor((FrameworkSupportModel)FrameworkSupportOptionsComponent.this.myModel);
            }
        };
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public LibraryCompositionSettings getLibraryCompositionSettings() {
        if (this.myLibraryCompositionSettings == null && this.myLibraryOptionsPanel != null) {
            this.myLibraryCompositionSettings = this.myLibraryOptionsPanel.apply();
        }
        return this.myLibraryCompositionSettings;
    }

    public LibraryOptionsPanel getLibraryOptionsPanel() {
        return this.myLibraryOptionsPanel;
    }
}

