/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultClassNavigationContributor
implements ChooseByNameContributorEx,
GotoClassContributor,
PossiblyDumbAware {
    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            return DefaultClassNavigationContributor.getQualifiedNameForClass((PsiClass)item);
        }
        return null;
    }

    public static String getQualifiedNameForClass(PsiClass psiClass) {
        String qName = psiClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        String containerText = SymbolPresentationUtil.getSymbolContainerText((PsiElement)psiClass);
        return containerText + "." + psiClass.getName();
    }

    public String getQualifiedNameSeparator() {
        return "$";
    }

    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        Project project = scope.getProject();
        FileBasedIndex.getInstance().ignoreDumbMode(() -> PsiShortNamesCache.getInstance((Project)project).processAllClassNames(processor2, scope, filter), DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE);
    }

    public void processElementsWithName(@NotNull String name2, final @NotNull Processor<? super NavigationItem> processor2, final @NotNull FindSymbolParameters parameters2) {
        Matcher matcher;
        String namePattern = StringUtil.getShortName((String)parameters2.getCompletePattern());
        boolean hasDollar = namePattern.contains("$");
        if (hasDollar && (matcher = ChooseByNamePopup.patternToDetectAnonymousClasses.matcher(namePattern)).matches()) {
            namePattern = matcher.group(1);
            hasDollar = namePattern.contains("$");
        }
        final MinusculeMatcher innerMatcher = hasDollar ? NameUtil.buildMatcher((String)("*" + namePattern)).build() : null;
        FileBasedIndex.getInstance().ignoreDumbMode(() -> PsiShortNamesCache.getInstance((Project)parameters2.getProject()).processClassesWithName(name2, (Processor)new Processor<PsiClass>(){
            final boolean isAnnotation;
            {
                this.isAnnotation = parameters2.getLocalPatternName().startsWith("@");
            }

            public boolean process(PsiClass aClass) {
                if (!DefaultClassNavigationContributor.isPhysical(aClass)) {
                    return true;
                }
                if (this.isAnnotation && !aClass.isAnnotationType()) {
                    return true;
                }
                if (innerMatcher != null) {
                    if (aClass.getContainingClass() == null) {
                        return true;
                    }
                    String jvmQName = ClassUtil.getJVMClassName((PsiClass)aClass);
                    if (jvmQName == null || !innerMatcher.matches(StringUtil.getShortName((String)jvmQName))) {
                        return true;
                    }
                }
                return processor2.process((Object)aClass);
            }
        }, parameters2.getSearchScope(), parameters2.getIdFilter()), DumbModeAccessType.RELIABLE_DATA_ONLY);
    }

    @Nullable
    public Language getElementLanguage() {
        return JavaLanguage.INSTANCE;
    }

    private static boolean isPhysical(PsiClass aClass) {
        PsiFile file = aClass.getContainingFile();
        return file != null && file.getVirtualFile() != null && aClass.isPhysical();
    }

    public boolean isDumbAware() {
        return FileBasedIndex.isIndexAccessDuringDumbModeEnabled();
    }
}

