/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperTypeGroup
implements Group,
ItemPresentation,
AccessLevelProvider {
    private final SmartPsiElementPointer mySuperClassPointer;
    private final OwnershipType myOverrides;
    private final Collection<TreeElement> myChildren = new ArrayList<TreeElement>();

    public SuperTypeGroup(PsiClass superClass, OwnershipType type2) {
        this.myOverrides = type2;
        this.mySuperClassPointer = SmartPointerManager.getInstance((Project)superClass.getProject()).createSmartPsiElementPointer((PsiElement)superClass);
    }

    @NotNull
    public Collection<TreeElement> getChildren() {
        return this.myChildren;
    }

    @Nullable
    private PsiClass getSuperClass() {
        return (PsiClass)this.mySuperClassPointer.getElement();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    public Icon getIcon(boolean open) {
        switch (this.myOverrides) {
            case IMPLEMENTS: {
                return AllIcons.General.ImplementingMethod;
            }
            case INHERITS: {
                return AllIcons.General.InheritedMethod;
            }
            case OVERRIDES: {
                return AllIcons.General.OverridingMethod;
            }
        }
        return null;
    }

    public String getLocationString() {
        return null;
    }

    public String getPresentableText() {
        return this.toString();
    }

    public String toString() {
        PsiClass superClass = this.getSuperClass();
        return superClass != null ? superClass.getName() : StructureViewBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SuperTypeGroup)) {
            return false;
        }
        SuperTypeGroup superTypeGroup = (SuperTypeGroup)o;
        if (this.myOverrides != superTypeGroup.myOverrides) {
            return false;
        }
        PsiClass superClass = this.getSuperClass();
        return !(superClass != null ? !superClass.equals(superTypeGroup.getSuperClass()) : superTypeGroup.getSuperClass() != null);
    }

    public int hashCode() {
        PsiClass superClass = this.getSuperClass();
        return superClass != null ? superClass.hashCode() : 0;
    }

    public Object getValue() {
        return this;
    }

    @Override
    public int getAccessLevel() {
        PsiClass superClass = this.getSuperClass();
        PsiModifierList modifierList = superClass == null ? null : superClass.getModifierList();
        return modifierList == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList);
    }

    @Override
    public int getSubLevel() {
        return 1;
    }

    public void addMethod(TreeElement superMethod) {
        this.myChildren.add(superMethod);
    }

    public static enum OwnershipType {
        IMPLEMENTS,
        OVERRIDES,
        INHERITS;

    }
}

