/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PackageViewProjectNode
extends AbstractProjectNode {
    public PackageViewProjectNode(@NotNull Project project, ViewSettings viewSettings) {
        super(project, project, viewSettings);
    }

    public boolean canRepresent(Object element) {
        Project project = (Project)this.getValue();
        if (project == element) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            element = directory.getVirtualFile();
        }
        if (element instanceof VirtualFile) {
            ProjectRootManager manager;
            ProjectRootManager projectRootManager = manager = project == null || project.isDisposed() ? null : ProjectRootManager.getInstance((Project)project);
            if (manager != null) {
                for (VirtualFile root : manager.getContentSourceRoots()) {
                    if (!element.equals(root)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        if (this.getSettings().isShowModules()) {
            ArrayList<LoadedModuleDescriptionImpl> modulesWithSourceRoots = new ArrayList<LoadedModuleDescriptionImpl>();
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (ModuleRootManager.getInstance((Module)module).getSourceRoots().length <= 0) continue;
                modulesWithSourceRoots.add(new LoadedModuleDescriptionImpl(module));
            }
            return this.modulesAndGroups(modulesWithSourceRoots);
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList children = new ArrayList();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : projectRootManager.getContentSourceRoots()) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(directory, this.getSettings(), false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage psiPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, psiPackage, null, this.getSettings(), false);
        }
        if (this.getSettings().isShowLibraryContents()) {
            children.add((AbstractTreeNode<?>)new PackageViewLibrariesNode(this.getProject(), null, this.getSettings()));
        }
        return children;
    }

    @NotNull
    protected AbstractTreeNode createModuleGroup(@NotNull Module module) {
        return new PackageViewModuleNode(this.getProject(), module, this.getSettings());
    }

    @NotNull
    protected AbstractTreeNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        return new PackageViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    public boolean someChildContainsFile(VirtualFile file) {
        return true;
    }
}

