/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.google.common.collect.ImmutableList;
import com.intellij.ide.navigationToolbar.StructureAwareNavBarModelExtension;
import com.intellij.ide.structureView.impl.java.JavaAnonymousClassesNodeProvider;
import com.intellij.ide.structureView.impl.java.JavaLambdaNodeProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageViewShortNameLocation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaNavBarExtension
extends StructureAwareNavBarModelExtension {
    private final List<NodeProvider<?>> myNodeProviders = ImmutableList.of((Object)new JavaLambdaNodeProvider(), (Object)new JavaAnonymousClassesNodeProvider());

    @Nullable
    public String getPresentableText(Object object) {
        return this.getPresentableText(object, false);
    }

    public String getPresentableText(Object object, boolean forPopup) {
        if (object instanceof PsiMember) {
            if (forPopup && object instanceof PsiMethod) {
                return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)object), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)261, (int)2);
            }
            return ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)object), (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        }
        if (object instanceof PsiPackage) {
            String name2 = ((PsiPackage)object).getName();
            return name2 != null ? name2 : JavaBundle.message((String)"dependencies.tree.node.default.package.abbreviation", (Object[])new Object[0]);
        }
        if (object instanceof PsiDirectory && JrtFileSystem.isRoot((VirtualFile)((PsiDirectory)object).getVirtualFile())) {
            return JavaBundle.message((String)"jrt.node.short", (Object[])new Object[0]);
        }
        if (object instanceof PsiLambdaExpression) {
            return "Lambda";
        }
        return null;
    }

    public PsiElement getParent(PsiElement psiElement) {
        PsiPackage parentPackage;
        if (psiElement instanceof PsiPackage && (parentPackage = ((PsiPackage)psiElement).getParentPackage()) != null && parentPackage.getQualifiedName().length() > 0) {
            return parentPackage;
        }
        return super.getParent(psiElement);
    }

    @Nullable
    public PsiElement adjustElement(@NotNull PsiElement psiElement) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file != null && (index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || index.isInLibrary(file))) {
                PsiClass[] psiClasses;
                PsiJavaFile psiJavaFile;
                if (psiElement instanceof PsiJavaFile && (psiJavaFile = (PsiJavaFile)psiElement).getViewProvider().getBaseLanguage() == JavaLanguage.INSTANCE && (psiClasses = psiJavaFile.getClasses()).length == 1) {
                    return psiClasses[0];
                }
                if (!UISettings.getInstance().getShowMembersInNavigationBar() && psiElement instanceof PsiClass) {
                    return psiElement;
                }
            }
            if (!UISettings.getInstance().getShowMembersInNavigationBar()) {
                return containingFile;
            }
        }
        return psiElement;
    }

    @NotNull
    protected Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    @NotNull
    protected List<NodeProvider<?>> getApplicableNodeProviders() {
        return this.myNodeProviders;
    }

    protected boolean acceptParentFromModel(@Nullable PsiElement psiElement) {
        if (psiElement instanceof PsiJavaFile) {
            return ((PsiJavaFile)psiElement).getClasses().length > 1;
        }
        return true;
    }
}

