/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;

public final class FileClassMacro
extends Macro {
    @NotNull
    public String getName() {
        return "FileClass";
    }

    @NotNull
    public String getDescription() {
        return JavaBundle.message((String)"macro.class.name", (Object[])new Object[0]);
    }

    public String expand(@NotNull DataContext dataContext) {
        PsiFile javaFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (!(javaFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes2 = ((PsiJavaFile)javaFile).getClasses();
        if (classes2.length == 1) {
            return classes2[0].getQualifiedName();
        }
        String fileName = javaFile.getVirtualFile().getNameWithoutExtension();
        for (PsiClass aClass : classes2) {
            String name2 = aClass.getName();
            if (!fileName.equals(name2)) continue;
            return aClass.getQualifiedName();
        }
        return null;
    }
}

