/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    public static PsiClass createClassOrInterface(Project project, PsiDirectory directory, String content, boolean reformat, String extension) throws IncorrectOperationException {
        PsiElement addedElement;
        if (extension == null) {
            extension = JavaFileType.INSTANCE.getDefaultExtension();
        }
        String name2 = "myClass." + extension;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(name2, (Language)JavaLanguage.INSTANCE, (CharSequence)content, false, false);
        psiFile.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, (Object)LanguageLevel.JDK_14_PREVIEW);
        if (!(psiFile instanceof PsiJavaFile)) {
            throw new IncorrectOperationException("This template did not produce a Java class or an interface\n" + psiFile.getText());
        }
        PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
        PsiClass[] classes2 = psiJavaFile.getClasses();
        if (classes2.length == 0) {
            throw new IncorrectOperationException("This template did not produce a Java class or an interface\n" + psiFile.getText());
        }
        PsiClass createdClass = classes2[0];
        String className2 = createdClass.getName();
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(directory, className2);
        LanguageLevel ll = JavaDirectoryService.getInstance().getLanguageLevel(directory);
        if (ll.compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
            if (createdClass.isAnnotationType()) {
                throw new IncorrectOperationException("Annotations only supported at language level 1.5 and higher");
            }
            if (createdClass.isEnum()) {
                throw new IncorrectOperationException("Enums only supported at language level 1.5 and higher");
            }
        }
        if ((addedElement = directory.add((PsiElement)(psiJavaFile = (PsiJavaFile)psiJavaFile.setName(className2 + "." + extension)))) instanceof PsiJavaFile) {
            psiJavaFile = (PsiJavaFile)addedElement;
            if (reformat) {
                CodeStyleManager.getInstance((Project)project).scheduleReformatWhenSettingsComputed((PsiFile)psiJavaFile);
            }
            return psiJavaFile.getClasses()[0];
        }
        PsiFile containingFile = addedElement.getContainingFile();
        throw new IncorrectOperationException("Selected class file name '" + containingFile.getName() + "' mapped to not java file type '" + containingFile.getFileType().getDescription() + "'");
    }

    static void hackAwayEmptyPackage(PsiJavaFile file, FileTemplate template, Map<String, Object> props) throws IncorrectOperationException {
        PsiPackageStatement packageStatement;
        if (!template.isTemplateOfType((FileType)JavaFileType.INSTANCE)) {
            return;
        }
        String packageName = (String)props.get("PACKAGE_NAME");
        if ((packageName == null || packageName.length() == 0 || packageName.equals("PACKAGE_NAME")) && (packageStatement = file.getPackageStatement()) != null) {
            packageStatement.delete();
        }
    }

    public boolean handlesTemplate(@NotNull FileTemplate template) {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        return fileType.equals((Object)JavaFileType.INSTANCE) && !ArrayUtil.contains((String)template.getName(), (String[])JavaTemplateUtil.INTERNAL_FILE_TEMPLATES);
    }

    @NotNull
    public PsiElement createFromTemplate(@NotNull Project project, @NotNull PsiDirectory directory, String fileName, @NotNull FileTemplate template, @NotNull String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        String extension = template.getExtension();
        PsiClass result = JavaCreateFromTemplateHandler.createClassOrInterface(project, directory, templateText, template.isReformatCode(), extension);
        JavaCreateFromTemplateHandler.hackAwayEmptyPackage((PsiJavaFile)result.getContainingFile(), template, props);
        return result;
    }

    public boolean canCreate(PsiDirectory @NotNull [] dirs) {
        for (PsiDirectory dir : dirs) {
            if (!JavaCreateFromTemplateHandler.canCreate(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameRequired() {
        return false;
    }

    @NotNull
    public String getErrorMessage() {
        return JavaBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]);
    }

    public void prepareProperties(@NotNull Map<String, Object> props) {
        String packageName = (String)props.get("PACKAGE_NAME");
        if (packageName == null || packageName.length() == 0) {
            props.put("PACKAGE_NAME", "PACKAGE_NAME");
        }
    }

    @NotNull
    public String commandName(@NotNull FileTemplate template) {
        return JavaBundle.message((String)"command.create.class.from.template", (Object[])new Object[0]);
    }

    public static boolean canCreate(PsiDirectory dir) {
        return JavaDirectoryService.getInstance().getPackage(dir) != null;
    }
}

