/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import org.jetbrains.annotations.NotNull;

public class NewProjectAction
extends AnAction
implements DumbAware,
NewProjectOrModuleAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        NewProjectWizard wizard = new NewProjectWizard(null, ModulesProvider.EMPTY_MODULES_PROVIDER, null);
        NewProjectUtil.createNewProject(wizard);
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            Presentation presentation = e.getPresentation();
            presentation.setIcon(AllIcons.Welcome.CreateNewProject);
            if (Registry.is((String)"use.tabbed.welcome.screen")) {
                presentation.setIcon(AllIcons.Welcome.CreateNewProjectTab);
                presentation.setSelectedIcon(AllIcons.Welcome.CreateNewProjectTabSelected);
            }
        }
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        return JavaUiBundle.message("new.project.action.text", isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0);
    }

    public static <T extends AnAction> void updateActionText(@NotNull T action, @NotNull AnActionEvent e) {
        String actionText;
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            actionText = action.getTemplateText();
        } else {
            boolean inJavaIde = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages().contains(JavaLanguage.INSTANCE);
            boolean fromNewSubMenu = NewProjectAction.isInvokedFromNewSubMenu(action, e);
            actionText = ((NewProjectOrModuleAction)action).getActionText(fromNewSubMenu, inJavaIde);
        }
        e.getPresentation().setText(actionText);
    }

    private static boolean isInvokedFromNewSubMenu(@NotNull AnAction action, @NotNull AnActionEvent e) {
        return NewActionGroup.isActionInNewPopupMenu((AnAction)action) && ("MainMenu".equals(e.getPlace()) || ActionPlaces.isPopupPlace((String)e.getPlace()));
    }
}

