/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class CreateModuleInfoAction
extends CreateFromTemplateActionBase {
    public CreateModuleInfoAction() {
        super(JavaBundle.messagePointer((String)"action.create.new.module-info.title", (Object[])new Object[0]), JavaBundle.messagePointer((String)"action.create.new.module-info.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
    }

    public void update(@NotNull AnActionEvent e) {
        PsiDirectory target;
        DataContext ctx = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(ctx);
        PsiDirectory psiDirectory = target = view != null && e.getProject() != null ? this.getTargetDirectory(ctx, view) : null;
        if (target == null || !PsiUtil.isLanguageLevel9OrHigher(target)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(JavaModuleGraphUtil.findDescriptorByElement((PsiElement)target) == null);
        }
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext ctx, IdeView view) {
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 1) {
            VirtualFile root;
            PsiDirectory psiDir = directories[0];
            VirtualFile vDir = psiDir.getVirtualFile();
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)psiDir.getProject()).getFileIndex();
            if (index.isUnderSourceRootOfType(vDir, ContainerUtil.set((Object[])new JavaSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE})) && (root = index.getSourceRootForFile(vDir)) != null) {
                return psiDir.getManager().findDirectory(root);
            }
        }
        return null;
    }

    protected FileTemplate getTemplate(@NotNull Project project, @NotNull PsiDirectory dir) {
        return FileTemplateManager.getInstance((Project)project).getInternalTemplate("module-info");
    }

    protected AttributesDefaults getAttributesDefaults(@NotNull DataContext ctx) {
        return new AttributesDefaults("module-info").withFixedName(true);
    }

    protected Map<String, String> getLiveTemplateDefaults(@NotNull DataContext ctx, @NotNull PsiFile file) {
        Module module = (Module)LangDataKeys.MODULE.getData(ctx);
        return Collections.singletonMap("MODULE_NAME", module != null ? LightJavaModule.moduleName(module.getName()) : "module_name");
    }
}

