/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaPackageFindUsagesOptions
extends JavaFindUsagesOptions {
    public boolean isClassesUsages;
    public boolean isIncludeSubpackages = true;
    public boolean isSkipPackageStatements;

    public JavaPackageFindUsagesOptions(@NotNull Project project) {
        super(project);
    }

    public JavaPackageFindUsagesOptions(@NotNull SearchScope searchScope) {
        super(searchScope);
    }

    @Override
    protected void setDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        super.setDefaults(properties, prefix);
        this.isClassesUsages = properties.getBoolean(prefix + "isClassesUsages");
        this.isIncludeSubpackages = properties.getBoolean(prefix + "isIncludeSubpackages", true);
        this.isSkipPackageStatements = properties.getBoolean(prefix + "isSkipPackageStatements");
    }

    @Override
    protected void storeDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        super.storeDefaults(properties, prefix);
        properties.setValue(prefix + "isClassesUsages", this.isClassesUsages);
        properties.setValue(prefix + "isIncludeSubpackages", this.isIncludeSubpackages, true);
        properties.setValue(prefix + "isSkipPackageStatements", this.isSkipPackageStatements);
    }

    @Override
    protected void addUsageTypes(@NotNull Set<? super String> to) {
        if (this.isUsages || this.isClassesUsages) {
            to.add(AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaPackageFindUsagesOptions that = (JavaPackageFindUsagesOptions)((Object)o);
        if (this.isClassesUsages != that.isClassesUsages) {
            return false;
        }
        if (this.isIncludeSubpackages != that.isIncludeSubpackages) {
            return false;
        }
        return this.isSkipPackageStatements == that.isSkipPackageStatements;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isClassesUsages ? 1 : 0);
        result = 31 * result + (this.isIncludeSubpackages ? 1 : 0);
        result = 31 * result + (this.isSkipPackageStatements ? 1 : 0);
        return result;
    }
}

