/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.JreProvider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.JdkBundle;
import org.jetbrains.annotations.NotNull;

public class BundledJreProvider
implements JreProvider {
    private final JdkBundle myBundle = JdkBundle.createBundled();

    @Override
    @NotNull
    public String getJrePath() {
        assert (this.myBundle != null);
        return BundledJreProvider.getPatchedJrePath(this.myBundle.getLocation().getPath());
    }

    @NotNull
    public static String getPatchedJrePath(@NotNull String path) {
        if (SystemInfo.isMac && !path.endsWith("/Contents/Home")) {
            path = path + "/Contents/Home";
        }
        return path;
    }

    @Override
    public String getPresentableName() {
        return "Bundled";
    }

    @Override
    public boolean isAvailable() {
        return Registry.is((String)"ide.java.show.bundled.runtime") && this.myBundle != null;
    }
}

