/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchForTestsTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(SearchForTestsTask.class);
    protected Socket mySocket;
    private final ServerSocket myServerSocket;
    private ProgressIndicator myProcessIndicator;

    public SearchForTestsTask(@Nullable Project project, ServerSocket socket) {
        super(project, ExecutionBundle.message((String)"searching.test.progress.title", (Object[])new Object[0]), true);
        this.myServerSocket = socket;
    }

    protected abstract void search() throws ExecutionException;

    protected abstract void onFound() throws ExecutionException;

    public void ensureFinished() {
        if (this.myProcessIndicator != null && !this.myProcessIndicator.isCanceled()) {
            this.finish();
        }
    }

    public void startSearch() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.search();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        } else {
            this.myProcessIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)this);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, this.myProcessIndicator);
        }
    }

    public void attachTaskToProcess(final OSProcessHandler handler) {
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                handler.removeProcessListener((ProcessListener)this);
                SearchForTestsTask.this.ensureFinished();
            }

            public void startNotified(@NotNull ProcessEvent event) {
                SearchForTestsTask.this.startSearch();
            }
        });
    }

    protected boolean requiresSmartMode() {
        return true;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        try {
            this.mySocket = this.myServerSocket.accept();
            ExecutionException[] ex = new ExecutionException[1];
            NonBlockingReadAction readAction = ReadAction.nonBlocking(() -> {
                try {
                    this.search();
                }
                catch (ExecutionException e) {
                    ex[0] = e;
                }
            });
            if (this.requiresSmartMode()) {
                readAction = readAction.inSmartMode(this.myProject);
            }
            readAction.executeSynchronously();
            if (ex[0] != null) {
                this.logCantRunException(ex[0]);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    protected void logCantRunException(ExecutionException e) throws ExecutionException {
        throw e;
    }

    public void onCancel() {
        this.finish();
    }

    public void onSuccess() {
        Runnable runnable = () -> {
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            this.finish();
        };
        if (this.requiresSmartMode()) {
            DumbService.getInstance((Project)this.getProject()).runWhenSmart(runnable);
        } else {
            runnable.run();
        }
    }

    public void finish() {
        FilterOutputStream os = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            os = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)os).writeBoolean(true);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            try {
                if (!this.myServerSocket.isClosed()) {
                    this.myServerSocket.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }
}

