/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiMethodUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        public Class<? extends BaseState> getOptionsClass() {
            return JvmMainMethodRunConfigurationOptions.class;
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            return new ApplicationConfiguration("", project, ApplicationConfigurationType.this);
        }

        @NotNull
        public String getId() {
            return ApplicationConfigurationType.this.getId();
        }
    };

    @NotNull
    public String getDisplayName() {
        return ExecutionBundle.message((String)"application.configuration.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"application.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Application;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.Application";
    }

    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    public static PsiClass getMainClass(PsiElement element) {
        while (element != null) {
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                if (PsiMethodUtil.findMainInClass((PsiClass)aClass) != null) {
                    return aClass;
                }
            } else if (element instanceof PsiJavaFile) {
                PsiClass[] classes2;
                for (PsiClass aClass : classes2 = ((PsiJavaFile)element).getClasses()) {
                    if (PsiMethodUtil.findMainInClass((PsiClass)aClass) == null) continue;
                    return aClass;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public String getId() {
        return "Application";
    }

    @NotNull
    public String getTag() {
        String id = this.getId();
        return id.equals("Application") ? "java" : id;
    }

    @NotNull
    public static ApplicationConfigurationType getInstance() {
        return (ApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(ApplicationConfigurationType.class);
    }
}

