/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.AlternativeSdkRootsProvider;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.application.ApplicationCommandLineState;
import com.intellij.execution.application.ApplicationConfigurable;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.application.JavaApplicationSettingsEditor;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.java.JavaLanguageRuntimeType;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements CommonJavaRunConfigurationParameters,
ConfigurationWithCommandLineShortener,
SingleClassConfiguration,
RefactoringListenerProvider,
InputRedirectAware,
TargetEnvironmentAwareRunProfile {
    @Deprecated
    public String MAIN_CLASS_NAME;
    @Deprecated
    public String PROGRAM_PARAMETERS;
    @Deprecated
    public String WORKING_DIRECTORY;
    @Deprecated
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    @Deprecated
    public String ALTERNATIVE_JRE_PATH;

    public ApplicationConfiguration(String name2, @NotNull Project project, @NotNull ApplicationConfigurationType configurationType) {
        this(name2, project, configurationType.getConfigurationFactories()[0]);
    }

    public ApplicationConfiguration(String name2, @NotNull Project project) {
        this(name2, project, ApplicationConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    protected ApplicationConfiguration(String name2, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        super(name2, (RunConfigurationModule)new JavaRunConfigurationModule(project, true), factory);
    }

    @NotNull
    protected final Class<? extends JvmMainMethodRunConfigurationOptions> getDefaultOptionsClass() {
        return JvmMainMethodRunConfigurationOptions.class;
    }

    @NotNull
    protected JvmMainMethodRunConfigurationOptions getOptions() {
        return (JvmMainMethodRunConfigurationOptions)super.getOptions();
    }

    @Override
    public void setMainClass(@NotNull PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        JavaApplicationCommandLineState<ApplicationConfiguration> state = new JavaApplicationCommandLineState<ApplicationConfiguration>(this, env);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module.getSearchScope()));
        return state;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        if (Registry.is((String)"ide.new.run.config", (boolean)true)) {
            return new JavaApplicationSettingsEditor(this);
        }
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return group;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
        return RunConfigurationExtension.wrapRefactoringElementListener(element, (RunConfigurationBase)this, listener);
    }

    @Override
    @Nullable
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.getMainClassName());
    }

    @Nullable
    public String getMainClassName() {
        return this.MAIN_CLASS_NAME;
    }

    @Nullable
    public String suggestedName() {
        if (this.getMainClassName() == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
    }

    public String getActionName() {
        if (this.getMainClassName() == null) {
            return null;
        }
        return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.getMainClassName()), (int)6) + ".main()";
    }

    @Override
    public void setMainClassName(@Nullable String qualifiedName) {
        this.MAIN_CLASS_NAME = qualifiedName;
        this.getOptions().setMainClassName(qualifiedName);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(this.getMainClassName(), ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        if (!PsiMethodUtil.hasMainMethod((PsiClass)psiClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])new Object[]{this.getMainClassName()}));
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)configurationModule.getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid(this);
    }

    @Override
    public void setVMParameters(@Nullable String value2) {
        this.getOptions().setVmParameters(value2);
    }

    @Override
    public String getVMParameters() {
        return this.getOptions().getVmParameters();
    }

    public void setProgramParameters(@Nullable String value2) {
        this.PROGRAM_PARAMETERS = value2;
        this.getOptions().setProgramParameters(value2);
    }

    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String value2) {
        String normalizedValue = StringUtil.isEmptyOrSpaces((String)value2) ? null : value2.trim();
        this.WORKING_DIRECTORY = PathUtil.toSystemDependentName((String)normalizedValue);
        String independentValue = PathUtil.toSystemIndependentName((String)normalizedValue);
        this.getOptions().setWorkingDirectory(Objects.equals(independentValue, this.getProject().getBasePath()) ? null : independentValue);
    }

    public String getWorkingDirectory() {
        return this.WORKING_DIRECTORY;
    }

    public void setPassParentEnvs(boolean value2) {
        this.getOptions().setPassParentEnv(value2);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.getOptions().getEnv();
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        this.getOptions().setEnv(envs);
    }

    public boolean isPassParentEnvs() {
        return this.getOptions().isPassParentEnv();
    }

    @Override
    @Nullable
    public String getRunClass() {
        return this.getMainClassName();
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean enabled) {
        boolean changed = this.ALTERNATIVE_JRE_PATH_ENABLED != enabled;
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
        this.getOptions().setAlternativeJrePathEnabled(enabled);
        ApplicationConfiguration.onAlternativeJreChanged(changed, this.getProject());
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(@Nullable String path) {
        boolean changed = !Objects.equals(this.ALTERNATIVE_JRE_PATH, path);
        this.ALTERNATIVE_JRE_PATH = path;
        this.getOptions().setAlternativeJrePath(path);
        ApplicationConfiguration.onAlternativeJreChanged(changed, this.getProject());
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        return target.getRuntimes().findByType(JavaLanguageRuntimeConfiguration.class) != null;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(JavaLanguageRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    public static void onAlternativeJreChanged(boolean changed, Project project) {
        if (changed) {
            AlternativeSdkRootsProvider.reindexIfNeeded(project);
        }
    }

    public boolean isProvidedScopeIncluded() {
        return this.getOptions().isIncludeProvidedScope();
    }

    public void setIncludeProvidedScope(boolean value2) {
        this.getOptions().setIncludeProvidedScope(value2);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.getMainClassName());
    }

    public void readExternal(@NotNull Element element) {
        super.readExternal(element);
        this.syncOldStateFields();
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    private void syncOldStateFields() {
        JvmMainMethodRunConfigurationOptions options = this.getOptions();
        String workingDirectory = options.getWorkingDirectory();
        workingDirectory = workingDirectory == null ? PathUtil.toSystemDependentName((String)this.getProject().getBasePath()) : FileUtilRt.toSystemDependentName((String)VirtualFileManager.extractPath((String)workingDirectory));
        this.MAIN_CLASS_NAME = options.getMainClassName();
        this.PROGRAM_PARAMETERS = options.getProgramParameters();
        this.WORKING_DIRECTORY = workingDirectory;
        this.ALTERNATIVE_JRE_PATH = options.getAlternativeJrePath();
        this.ALTERNATIVE_JRE_PATH_ENABLED = options.isAlternativeJrePathEnabled();
    }

    public void setOptionsFromConfigurationFile(@NotNull BaseState state) {
        super.setOptionsFromConfigurationFile(state);
        this.syncOldStateFields();
    }

    public void writeExternal(@NotNull Element element) {
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.getOptions().getShortenClasspath();
    }

    public void setShortenCommandLine(@Nullable ShortenCommandLine mode) {
        this.getOptions().setShortenClasspath(mode);
    }

    @NotNull
    public InputRedirectAware.InputRedirectOptions getInputRedirectOptions() {
        return this.getOptions().getRedirectOptions();
    }

    public boolean isSwingInspectorEnabled() {
        return this.getOptions().isSwingInspectorEnabled();
    }

    public void setSwingInspectorEnabled(boolean value2) {
        this.getOptions().setSwingInspectorEnabled(value2);
    }

    public Module getDefaultModule() {
        Module module;
        PsiClass mainClass = this.getMainClass();
        if (mainClass != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)mainClass)) != null) {
            return module;
        }
        return super.getDefaultModule();
    }

    public static class JavaApplicationCommandLineState<T extends ApplicationConfiguration>
    extends ApplicationCommandLineState<T> {
        public JavaApplicationCommandLineState(@NotNull T configuration, ExecutionEnvironment environment) {
            super(configuration, environment);
        }

        @Override
        protected boolean isProvidedScopeIncluded() {
            return ((ApplicationConfiguration)this.myConfiguration).isProvidedScopeIncluded();
        }
    }
}

