/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractApplicationConfigurationProducer<T extends ApplicationConfiguration>
extends JavaRunConfigurationProducerBase<T> {
    public AbstractApplicationConfigurationProducer() {
    }

    @Deprecated
    public AbstractApplicationConfigurationProducer(@NotNull ApplicationConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (!element.isPhysical()) {
            return false;
        }
        PsiClass aClass = ApplicationConfigurationType.getMainClass(element);
        if (aClass == null) {
            return false;
        }
        PsiMethod method = PsiMethodUtil.findMainInClass((PsiClass)aClass);
        if (method != null && PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)element, (boolean)false)) {
            sourceElement.set((Object)method);
            this.setupConfiguration(configuration, aClass, context);
            return true;
        }
        sourceElement.set((Object)aClass);
        this.setupConfiguration(configuration, aClass, context);
        return true;
    }

    private void setupConfiguration(T configuration, PsiClass aClass, ConfigurationContext context) {
        ((ApplicationConfiguration)configuration).setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
    }

    public boolean isConfigurationFromContext(@NotNull T appConfiguration, @NotNull ConfigurationContext context) {
        PsiElement location = context.getPsiLocation();
        PsiClass aClass = ApplicationConfigurationType.getMainClass(location);
        if (aClass != null && Objects.equals(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), ((ApplicationConfiguration)appConfiguration).getMainClassName())) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location, PsiMethod.class, (boolean)false);
            if (method != null && TestFrameworks.getInstance().isTestMethod(method)) {
                return false;
            }
            Module configurationModule = ((JavaRunConfigurationModule)appConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
                return true;
            }
            ApplicationConfiguration template = (ApplicationConfiguration)context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory()).getConfiguration();
            Module predefinedModule = ((JavaRunConfigurationModule)template.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }
}

