/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueIconRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundReferenceRenderer
extends NodeRendererImpl
implements FullValueEvaluatorProvider {
    protected static final Logger LOG = Logger.getInstance(CompoundReferenceRenderer.class);
    private static final AutoToStringRenderer AUTO_TO_STRING_RENDERER = new AutoToStringRenderer();
    @NonNls
    public static final String UNIQUE_ID = "CompoundNodeRenderer";
    @NonNls
    public static final String UNIQUE_ID_OLD = "CompoundTypeRenderer";
    private ValueLabelRenderer myLabelRenderer;
    private ChildrenRenderer myChildrenRenderer;
    private ValueIconRenderer myIconRenderer = null;
    protected final NodeRendererSettings myRendererSettings;
    private FullValueEvaluatorProvider myFullValueEvaluatorProvider;

    public CompoundReferenceRenderer(NodeRendererSettings rendererSettings, String name2, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        super(name2);
        this.myRendererSettings = rendererSettings;
        this.myLabelRenderer = labelRenderer;
        this.myChildrenRenderer = childrenRenderer;
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(labelRenderer == null || labelRenderer instanceof ReferenceRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof ReferenceRenderer);
    }

    public CompoundReferenceRenderer(String name2, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        this(NodeRendererSettings.getInstance(), name2, labelRenderer, childrenRenderer);
    }

    @Override
    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        this.getChildrenRenderer().buildChildren(value2, builder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return this.getChildrenRenderer().getChildValueExpression(node, context);
    }

    @Override
    public CompletableFuture<Boolean> isExpandableAsync(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.getChildrenRenderer().isExpandableAsync(value2, evaluationContext, parentDescriptor);
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        return this.getLabelRenderer().calcLabel(descriptor, evaluationContext, listener);
    }

    @Override
    @Nullable
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        if (this.myIconRenderer != null) {
            return this.myIconRenderer.calcValueIcon(descriptor, evaluationContext, listener);
        }
        return null;
    }

    void setIconRenderer(ValueIconRenderer iconRenderer) {
        this.myIconRenderer = iconRenderer;
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, ValueDescriptorImpl valueDescriptor) {
        if (this.myFullValueEvaluatorProvider != null) {
            return this.myFullValueEvaluatorProvider.getFullValueEvaluator(evaluationContext, valueDescriptor);
        }
        return null;
    }

    void setFullValueEvaluator(FullValueEvaluatorProvider fullValueEvaluatorProvider) {
        this.myFullValueEvaluatorProvider = fullValueEvaluatorProvider;
    }

    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        ValueLabelRenderer prevRenderer = this.getLabelRenderer();
        this.myLabelRenderer = this.isBaseRenderer(labelRenderer) ? null : labelRenderer;
        ValueLabelRenderer currentRenderer = this.getLabelRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer prevRenderer = this.getChildrenRenderer();
        this.myChildrenRenderer = this.isBaseRenderer(childrenRenderer) ? null : childrenRenderer;
        ChildrenRenderer currentRenderer = this.getChildrenRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    public ChildrenRenderer getChildrenRenderer() {
        return this.myChildrenRenderer != null ? this.myChildrenRenderer : this.getDefaultRenderer();
    }

    private NodeRenderer getDefaultRenderer() {
        String name2 = this.getClassName();
        if (TypeConversionUtil.isPrimitive((String)name2)) {
            return this.myRendererSettings.getPrimitiveRenderer();
        }
        return name2.endsWith("]") ? this.myRendererSettings.getArrayRenderer() : AUTO_TO_STRING_RENDERER;
    }

    public ValueLabelRenderer getLabelRenderer() {
        return this.myLabelRenderer != null ? this.myLabelRenderer : this.getDefaultRenderer();
    }

    private ChildrenRenderer getRawChildrenRenderer() {
        return this.myChildrenRenderer == this.getDefaultRenderer() ? null : this.myChildrenRenderer;
    }

    private ValueLabelRenderer getRawLabelRenderer() {
        return this.myLabelRenderer == this.getDefaultRenderer() ? null : this.myLabelRenderer;
    }

    public void setClassName(@NotNull String name2) {
        this.myProperties.setClassName(name2);
        if (this.getRawLabelRenderer() != null && this.myLabelRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)this.myLabelRenderer)).setClassName(name2);
        }
        if (this.getRawChildrenRenderer() != null && this.myChildrenRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)this.myChildrenRenderer)).setClassName(name2);
        }
    }

    @Override
    public boolean isApplicable(Type type2) {
        String className2 = this.getClassName();
        if (!StringUtil.isEmpty((String)className2)) {
            return DebuggerUtils.instanceOf((Type)type2, (String)className2);
        }
        return this.getLabelRenderer().isApplicable(type2) && this.getChildrenRenderer().isApplicable(type2);
    }

    @NotNull
    public String getClassName() {
        return this.myProperties.getClassName();
    }

    protected final PsiElement getContext(Project project, DebuggerContext context) {
        DebugProcess process2 = context.getDebugProcess();
        GlobalSearchScope scope = process2 != null ? process2.getSearchScope() : GlobalSearchScope.allScope((Project)project);
        return DebuggerUtils.findClass((String)this.getClassName(), (Project)project, (GlobalSearchScope)scope);
    }

    protected final PsiElement getChildValueExpression(String text2, DebuggerTreeNode node, DebuggerContext context) {
        Project project = node.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        return elementFactory.createExpressionFromText(text2, this.getContext(project, context));
    }

    public boolean isBaseRenderer(Renderer renderer) {
        return renderer == AUTO_TO_STRING_RENDERER || renderer == this.myRendererSettings.getClassRenderer() || renderer == this.myRendererSettings.getPrimitiveRenderer() || renderer == this.myRendererSettings.getArrayRenderer();
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public CompoundReferenceRenderer clone() {
        CompoundReferenceRenderer renderer = (CompoundReferenceRenderer)super.clone();
        renderer.myLabelRenderer = this.myLabelRenderer != null ? (ValueLabelRenderer)this.myLabelRenderer.clone() : null;
        renderer.myChildrenRenderer = this.myChildrenRenderer != null ? (ChildrenRenderer)this.myChildrenRenderer.clone() : null;
        return renderer;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        for (Element elem : element.getChildren("Renderer")) {
            String role = elem.getAttributeValue("role");
            if (role == null) continue;
            if ("label".equals(role)) {
                this.myLabelRenderer = (ValueLabelRenderer)this.myRendererSettings.readRenderer(elem);
                continue;
            }
            if (!"children".equals(role)) continue;
            this.myChildrenRenderer = (ChildrenRenderer)this.myRendererSettings.readRenderer(elem);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myLabelRenderer != null) {
            Element labelRendererElement = this.myRendererSettings.writeRenderer(this.myLabelRenderer);
            labelRendererElement.setAttribute("role", "label");
            element.addContent(labelRendererElement);
        }
        if (this.myChildrenRenderer != null) {
            Element childrenRendererElement = this.myRendererSettings.writeRenderer(this.myChildrenRenderer);
            childrenRendererElement.setAttribute("role", "children");
            element.addContent(childrenRendererElement);
        }
    }

    private static class AutoToStringRenderer
    extends ToStringRenderer {
        private AutoToStringRenderer() {
            this.setIsApplicableChecker(type2 -> CompletableFuture.completedFuture(type2 instanceof ReferenceType));
        }

        @Override
        public String getUniqueId() {
            return "AutoToString";
        }

        @Override
        public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
            return NodeRendererSettings.getInstance().getToStringRenderer().isOnDemand(evaluationContext, valueDescriptor);
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) {
            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
            ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
            CompletableFuture<Boolean> toStringApplicable = CompletableFuture.completedFuture(false);
            if (toStringRenderer.isEnabled()) {
                toStringApplicable = toStringRenderer.isApplicableAsync(descriptor.getType());
            }
            CompletionStage renderer = toStringApplicable.thenApply(applicable -> applicable != false ? toStringRenderer : nodeRendererSettings.getClassRenderer());
            return AutoToStringRenderer.calcLabel((CompletableFuture<NodeRenderer>)renderer, descriptor, evaluationContext, listener);
        }
    }
}

