/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunToCursorBreakpoint
extends SyntheticLineBreakpoint
implements SteppingBreakpoint {
    private final boolean myRestoreBreakpoints;
    @NotNull
    protected final SourcePosition myCustomPosition;

    protected RunToCursorBreakpoint(@NotNull Project project, @NotNull SourcePosition pos, boolean restoreBreakpoints) {
        super(project);
        this.myCustomPosition = pos;
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    @Override
    @NotNull
    public SourcePosition getSourcePosition() {
        return this.myCustomPosition;
    }

    @Override
    public int getLineIndex() {
        return this.myCustomPosition.getLine();
    }

    @Override
    protected String getFileName() {
        return this.myCustomPosition.getFile().getName();
    }

    @Override
    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        return JavaDebuggerBundle.message((String)"status.stopped.at.cursor", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        SourcePosition position = this.getSourcePosition();
        VirtualFile file = position.getFile().getVirtualFile();
        int line = position.getLine();
        for (XLineBreakpointType type2 : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            if (!(type2 instanceof JavaLineBreakpointType) || !type2.canPutAt(file, line, this.myProject)) continue;
            return (JavaLineBreakpointType)type2;
        }
        return null;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project, @NotNull XSourcePosition position, boolean restoreBreakpoints) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
        if (psiFile == null) {
            return null;
        }
        return new RunToCursorBreakpoint(project, SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset()), restoreBreakpoints);
    }

    @Override
    public void setRequestHint(RequestHint hint) {
    }

    @Override
    public boolean track() {
        return false;
    }
}

