/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.CallTracingPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties> {
    public JavaLineBreakpointType() {
        super("java-line", JavaDebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        super(id, title);
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        return new JavaLineBreakpointProperties();
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        return new LineBreakpoint<JavaLineBreakpointProperties>(project, (XBreakpoint)breakpoint);
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        SourcePosition pos = DebuggerUtilsEx.toSourcePosition(position, project);
        if (pos == null) {
            return Collections.emptyList();
        }
        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(pos, true);
        if (lambdas.isEmpty()) {
            return Collections.emptyList();
        }
        PsiElement startMethod = DebuggerUtilsEx.getContainingMethod(pos);
        if (lambdas.contains(startMethod) && lambdas.size() == 1) {
            return Collections.emptyList();
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(pos.getFile());
        if (document == null) {
            return Collections.emptyList();
        }
        SmartList res = new SmartList();
        if (!(startMethod instanceof PsiLambdaExpression)) {
            res.add(new LineJavaBreakpointVariant(position, startMethod, -1));
        }
        int ordinal = 0;
        for (PsiLambdaExpression lambda2 : lambdas) {
            PsiElement firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambda2, document, position.getLine());
            XSourcePositionImpl elementPosition = XSourcePositionImpl.createByElement((PsiElement)firstElem);
            if (elementPosition == null) continue;
            if (lambda2 == startMethod) {
                res.add(0, new LineJavaBreakpointVariant((XSourcePosition)elementPosition, (PsiElement)lambda2, ordinal++));
                continue;
            }
            res.add(new LambdaJavaBreakpointVariant((XSourcePosition)elementPosition, (PsiElement)lambda2, ordinal++));
        }
        res.add(new JavaBreakpointVariant(position));
        return res;
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties) {
            if (!(breakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        SourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties && !(breakpoint instanceof RunToCursorBreakpoint) && (ordinal = ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal()) > -1) {
            List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(position, true);
            if (ordinal < lambdas.size()) {
                return (PsiElement)lambdas.get(ordinal);
            }
        }
        return DebuggerUtilsEx.getContainingMethod(position);
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        PsiElement method;
        Breakpoint javaBreakpoint;
        Integer ordinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint);
        if (ordinal != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (method = this.getContainingMethod((LineBreakpoint)javaBreakpoint)) != null) {
            return DebuggerUtilsEx.intersectWithLine(method.getTextRange(), method.getContainingFile(), breakpoint.getLine());
        }
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        Integer ordinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint);
        if (ordinal != null && ordinal > -1) {
            return (XSourcePosition)ReadAction.compute(() -> {
                SourcePosition linePosition = JavaLineBreakpointType.createLineSourcePosition((XLineBreakpointImpl)breakpoint);
                if (linePosition != null) {
                    return DebuggerUtilsEx.toXSourcePosition(new PositionManagerImpl.JavaSourcePosition(linePosition, ordinal));
                }
                return null;
            });
        }
        return null;
    }

    @Nullable
    private static Integer getLambdaOrdinal(XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)breakpoint.getProperties();
        return properties != null ? properties.getLambdaOrdinal() : null;
    }

    @Nullable
    private static SourcePosition createLineSourcePosition(XLineBreakpointImpl breakpoint) {
        PsiFile psiFile;
        VirtualFile file = breakpoint.getFile();
        if (file != null && (psiFile = PsiManager.getInstance((Project)breakpoint.getProject()).findFile(file)) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)breakpoint.getLine());
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        return JavaLineBreakpointType.canPutAtElement(file, line, project, (PairFunction<? super PsiElement, ? super Document, Boolean>)((PairFunction)(element, document) -> {
            if (element instanceof PsiField) {
                PsiExpression initializer = ((PsiField)element).getInitializer();
                if (initializer != null && !PsiType.NULL.equals((Object)initializer.getType())) {
                    Object value2 = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer);
                    return value2 == null;
                }
                return false;
            }
            if (element instanceof PsiMethod) {
                PsiStatement[] statements;
                PsiCodeBlock body2 = ((PsiMethod)element).getBody();
                if (body2 != null && (statements = body2.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == line) {
                    return true;
                }
                return false;
            }
            return true;
        }));
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaLineBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (Registry.is((String)"debugger.call.tracing")) {
            return new CallTracingPropertiesPanel(project);
        }
        return null;
    }

    public class LambdaJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LambdaJavaBreakpointVariant(@NotNull XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            super(position, element, lambdaOrdinal);
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.LambdaBreakpoint;
        }
    }

    public class LineJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LineJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            super(position, element, lambdaOrdinal);
        }

        @Override
        @NotNull
        public String getText() {
            return "Line";
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement myElement;
        private final Integer myLambdaOrdinal;

        public ExactJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            super(position);
            this.myElement = element;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        public Icon getIcon() {
            return this.myElement != null ? this.myElement.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        @NotNull
        public String getText() {
            return this.myElement != null ? StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0) : "Line";
        }

        public TextRange getHighlightRange() {
            if (this.myElement != null) {
                return DebuggerUtilsEx.intersectWithLine(this.myElement.getTextRange(), this.myElement.getContainingFile(), this.mySourcePosition.getLine());
            }
            return null;
        }

        @NotNull
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.setLambdaOrdinal(this.myLambdaOrdinal);
            return properties;
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        public JavaBreakpointVariant(XSourcePosition position) {
            super((XLineBreakpointType)JavaLineBreakpointType.this, position);
        }
    }
}

