/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.DialogUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class FieldBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> {
    private JCheckBox myWatchAccessCheckBox;
    private JCheckBox myWatchModificationCheckBox;

    @NotNull
    public JComponent getComponent() {
        this.myWatchAccessCheckBox = new JCheckBox(JavaDebuggerBundle.message((String)"label.filed.breakpoint.properties.panel.field.access", (Object[])new Object[0]));
        this.myWatchModificationCheckBox = new JCheckBox(JavaDebuggerBundle.message((String)"label.filed.breakpoint.properties.panel.field.modification", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchAccessCheckBox);
        DialogUtil.registerMnemonic((AbstractButton)this.myWatchModificationCheckBox);
        Box watchBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchAccessCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchModificationCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)watchBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaDebuggerBundle.message((String)"label.group.watch.events", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox toCheck = null;
                if (!FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox.isSelected() && !FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox.isSelected()) {
                    Object source = e.getSource();
                    if (FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox.equals(source)) {
                        toCheck = FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox;
                    } else if (FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox.equals(source)) {
                        toCheck = FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myWatchAccessCheckBox.addActionListener(listener);
        this.myWatchModificationCheckBox.addActionListener(listener);
        return _panel;
    }

    public void loadFrom(@NotNull XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        this.myWatchAccessCheckBox.setSelected(((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_ACCESS);
        this.myWatchModificationCheckBox.setSelected(((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_MODIFICATION);
    }

    public void saveTo(@NotNull XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        boolean changed = ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_ACCESS != this.myWatchAccessCheckBox.isSelected();
        ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_ACCESS = this.myWatchAccessCheckBox.isSelected();
        changed = ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_MODIFICATION != this.myWatchModificationCheckBox.isSelected() || changed;
        ((JavaFieldBreakpointProperties)breakpoint.getProperties()).WATCH_MODIFICATION = this.myWatchModificationCheckBox.isSelected();
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }
}

