/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class DebuggerPanelsManager {
    private final Project myProject;

    public DebuggerPanelsManager(Project project) {
        this.myProject = project;
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        return this.attachVirtualMachine(new DefaultDebugUIEnvironment(environment, state, remoteConnection, pollConnection));
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(DebugUIEnvironment environment) throws ExecutionException {
        DebugEnvironment modelEnvironment = environment.getEnvironment();
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(this.myProject).attachVirtualMachine(modelEnvironment);
        if (debuggerSession == null) {
            return null;
        }
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(modelEnvironment.getSessionName(), environment.getReuseContent(), new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                return JavaDebugProcess.create(session, debuggerSession);
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    public static DebuggerPanelsManager getInstance(Project project) {
        return (DebuggerPanelsManager)project.getService(DebuggerPanelsManager.class);
    }
}

