/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.icons.AllIcons;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilteringProgressView
extends BorderLayoutPanel {
    private static final String LIMIT_REACHED_LABEL = "Limit has been reached";
    private static final String INTERRUPTED_LABEL = "Filtering has been interrupted";
    private final JProgressBar myProgressBar = new JProgressBar();
    private final BorderLayoutPanel myProgressPanel = new BorderLayoutPanel();
    private final JBLabel myStopButton = new JBLabel(StartupUiUtil.isUnderDarcula() ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
    private final JBLabel myProgressText = new JBLabel();
    private int myProceedCount = 0;
    private int myErrorCount = 0;
    private int myMatchedCount = 0;
    private boolean myIsInProcess = false;
    @Nullable
    private FilteringResult myCompletionReason = null;

    FilteringProgressView() {
        this.myStopButton.setOpaque(true);
        this.myProgressPanel.addToCenter((Component)this.myProgressBar);
        this.myProgressPanel.addToRight((Component)this.myStopButton);
        this.addToTop((Component)this.myProgressText);
        this.addToCenter((Component)this.myProgressPanel);
    }

    void addStopActionListener(final @NotNull Runnable listener) {
        this.myStopButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                listener.run();
            }
        });
    }

    void updateProgress(int proceedCount, int matchedCount, int errorCount) {
        if (this.myIsInProcess) {
            this.myProceedCount = proceedCount;
            this.myMatchedCount = matchedCount;
            this.myErrorCount = errorCount;
            this.myProgressBar.setValue(this.myProceedCount);
            this.myProgressText.setText(this.getDescription());
        }
    }

    void start(int totalCount) {
        this.reset();
        this.myIsInProcess = true;
        this.myProgressBar.setMinimum(0);
        this.myProgressBar.setMaximum(totalCount);
        this.myProgressBar.setValue(0);
        this.myProgressText.setText(this.getDescription());
        this.setProgressBarVisible(true);
    }

    void complete(@NotNull FilteringResult reason) {
        if (!this.myIsInProcess) {
            throw new IllegalStateException("First you need to start progress");
        }
        this.myIsInProcess = false;
        this.myCompletionReason = reason;
        this.myProgressText.setText(this.getDescription());
        this.setProgressBarVisible(false);
    }

    private void reset() {
        this.myIsInProcess = false;
        this.myErrorCount = 0;
        this.myProceedCount = 0;
        this.myMatchedCount = 0;
        this.myCompletionReason = null;
    }

    private void setProgressBarVisible(boolean value2) {
        this.myProgressPanel.setVisible(value2);
    }

    private String getDescription() {
        int total = this.myProgressBar.getMaximum();
        String itemsInfo = String.format("Shown: %d / %d", this.myMatchedCount, total);
        if (this.myIsInProcess || this.myCompletionReason == null) {
            return itemsInfo;
        }
        switch (this.myCompletionReason) {
            case ALL_CHECKED: {
                break;
            }
            case INTERRUPTED: {
                itemsInfo = String.format("%s (%s)", itemsInfo, INTERRUPTED_LABEL);
                break;
            }
            case LIMIT_REACHED: {
                itemsInfo = String.format("%s (%s)", itemsInfo, LIMIT_REACHED_LABEL);
            }
        }
        if (!this.myIsInProcess && this.myErrorCount != 0) {
            String errors = String.format("Errors: %d", this.myErrorCount);
            return String.format("<html>%s<br>%s</html>", itemsInfo, errors);
        }
        return itemsInfo;
    }
}

