/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.SimpleReferringObject;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ReferringObjectsInfo {
    private static final Logger LOG = Logger.getInstance(ReferringObjectsInfo.class);
    private final Map<ObjectReference, Integer> myReversedMap = new HashMap<ObjectReference, Integer>();
    private final List<? extends ObjectReference> myDirectMap;
    private final List<? extends List<Integer>> myReferrers;

    public ReferringObjectsInfo(@NotNull List<? extends ObjectReference> values, @NotNull List<? extends List<Integer>> referrers) {
        this.myDirectMap = values;
        for (int i = 0; i < values.size(); ++i) {
            this.myReversedMap.put(values.get(i), i);
        }
        this.myReferrers = referrers;
    }

    public boolean hasReferringObjectsFor(@NotNull ObjectReference reference) {
        return this.myReversedMap.containsKey(reference);
    }

    @NotNull
    public List<ObjectReference> getAllReferrers(@NotNull ObjectReference value2) {
        return this.myReferrers.get(this.myReversedMap.get(value2)).stream().distinct().map(ix -> this.myDirectMap.get((int)ix)).collect(Collectors.toList());
    }

    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull ObjectReference value2, long limit) {
        Integer index = this.myReversedMap.get(value2);
        if (index == null) {
            LOG.error("Could not find referring object for reference " + value2.toString());
            return Collections.emptyList();
        }
        return this.myReferrers.get(index).stream().distinct().limit(limit).map(ix -> this.myDirectMap.get((int)ix)).map(SimpleReferringObject::new).collect(Collectors.toList());
    }
}

