/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryAgentReferringObjectsProvider
implements ReferringObjectsProvider {
    private final int myObjectsToRequestLimit;
    private final Map<ObjectReference, ReferringObjectsInfo> myCachedRequests = new HashMap<ObjectReference, ReferringObjectsInfo>();

    public MemoryAgentReferringObjectsProvider(int limit) {
        this.myObjectsToRequestLimit = limit;
    }

    @Override
    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value2, long limit) throws EvaluateException {
        if (this.myCachedRequests.containsKey(value2)) {
            return this.myCachedRequests.get(value2).getReferringObjects(value2, limit);
        }
        for (ReferringObjectsInfo provider : this.myCachedRequests.values()) {
            if (!provider.hasReferringObjectsFor(value2)) continue;
            return provider.getReferringObjects(value2, limit);
        }
        MemoryAgent memoryAgent = MemoryAgent.get(evaluationContext.getDebugProcess());
        if (!memoryAgent.capabilities().canGetReferringObjects()) {
            throw new UnsupportedOperationException();
        }
        ReferringObjectsInfo roots = memoryAgent.findReferringObjects(evaluationContext, value2, this.myObjectsToRequestLimit);
        this.myCachedRequests.put(value2, roots);
        return roots.getReferringObjects(value2, limit);
    }
}

