/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.extractor.ProxyExtractor;
import com.intellij.debugger.memory.agent.parsers.BooleanParser;
import com.intellij.debugger.memory.agent.parsers.GcRootsPathsParser;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.LongValueParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryAgentOperations {
    private static final Key<MemoryAgent> MEMORY_AGENT_KEY = Key.create((String)"MEMORY_AGENT_KEY");
    private static final Logger LOG = Logger.getInstance(MemoryAgentOperations.class);

    MemoryAgentOperations() {
    }

    static long estimateObjectSize(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference) throws EvaluateException {
        Value result = MemoryAgentOperations.callMethod(evaluationContext, "size", Collections.singletonList(reference));
        return LongValueParser.INSTANCE.parse(result);
    }

    static long @NotNull [] estimateObjectsSizes(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ObjectReference> references) throws EvaluateException {
        ArrayReference array = MemoryAgentOperations.wrapWithArray(evaluationContext, references);
        Value result = MemoryAgentOperations.callMethod(evaluationContext, "estimateRetainedSize", Collections.singletonList(array));
        return LongArrayParser.INSTANCE.parse(result).stream().mapToLong(Long::longValue).toArray();
    }

    @NotNull
    static ReferringObjectsInfo findReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, int limit) throws EvaluateException {
        IntegerValue limitValue = evaluationContext.getDebugProcess().getVirtualMachineProxy().mirrorOf(limit);
        Value value2 = MemoryAgentOperations.callMethod(evaluationContext, "gcRoots", Arrays.asList(reference, limitValue));
        return GcRootsPathsParser.INSTANCE.parse(value2);
    }

    @NotNull
    static MemoryAgent getAgent(@NotNull DebugProcessImpl debugProcess) {
        MemoryAgent agent = (MemoryAgent)debugProcess.getUserData(MEMORY_AGENT_KEY);
        return agent == null ? MemoryAgentImpl.DISABLED : agent;
    }

    static void initializeAgent(@NotNull EvaluationContextImpl context) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MemoryAgent agent = MemoryAgentImpl.DISABLED;
        try {
            agent = new MemoryAgentImpl(MemoryAgentOperations.initializeCapabilities(context));
        }
        catch (EvaluateException e) {
            LOG.error("Could not initialize memory agent. ", (Throwable)e);
        }
        context.getDebugProcess().putUserData(MEMORY_AGENT_KEY, agent);
    }

    private static MemoryAgentCapabilities initializeCapabilities(@NotNull EvaluationContextImpl context) throws EvaluateException {
        ClassType proxyType = MemoryAgentOperations.getProxyType(context);
        boolean isAgentLoaded = MemoryAgentOperations.checkAgentCapability(context, proxyType, "isLoaded");
        if (!isAgentLoaded) {
            return MemoryAgentCapabilities.DISABLED;
        }
        MemoryAgentCapabilities.Builder builder = new MemoryAgentCapabilities.Builder();
        return builder.setCanEstimateObjectSize(MemoryAgentOperations.checkAgentCapability(context, proxyType, "canEstimateObjectSize")).setCanEstimateObjectsSizes(MemoryAgentOperations.checkAgentCapability(context, proxyType, "canEstimateObjectsSizes")).setCanFindGcRoots(MemoryAgentOperations.checkAgentCapability(context, proxyType, "canFindGcRoots")).buildLoaded();
    }

    @NotNull
    private static ClassType getProxyType(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        boolean valueBefore = evaluationContext.isAutoLoadClasses();
        try {
            ClassType classType = MemoryAgentOperations.getOrLoadProxyType(evaluationContext);
            return classType;
        }
        finally {
            evaluationContext.setAutoLoadClasses(valueBefore);
        }
    }

    private static ClassType getOrLoadProxyType(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        ClassObjectReference classObjectReference = (ClassObjectReference)evaluationContext.computeAndKeep(() -> {
            long start = System.currentTimeMillis();
            ReferenceType referenceType = MemoryAgentOperations.loadUtilityClass(evaluationContext);
            if (referenceType == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)"Could not load memory agent proxy class");
            }
            long duration = System.currentTimeMillis() - start;
            LOG.info("Loading of agent proxy class took " + duration + " ms");
            return referenceType.classObject();
        });
        return (ClassType)classObjectReference.reflectedType();
    }

    private static boolean checkAgentCapability(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String capabilityMethodName) {
        try {
            Value value2 = MemoryAgentOperations.callMethod(evaluationContext, proxyType, capabilityMethodName, Collections.emptyList());
            return BooleanParser.INSTANCE.parse(value2);
        }
        catch (EvaluateException e) {
            LOG.warn("Exception while capability checking: ", (Throwable)e);
            return false;
        }
    }

    private static Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull String methodName, @NotNull List<? extends Value> args) throws EvaluateException {
        ClassType proxyType = MemoryAgentOperations.getProxyType(evaluationContext);
        return MemoryAgentOperations.callMethod(evaluationContext, proxyType, methodName, args);
    }

    @NotNull
    private static Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String methodName, @NotNull List<? extends Value> args) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long start = System.currentTimeMillis();
        List<Method> methods = DebuggerUtilsEx.declaredMethodsByName(proxyType, methodName);
        if (methods.isEmpty()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Could not find method with such name: " + methodName));
        }
        if (methods.size() > 1) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Too many methods \"" + methodName + "\" found. Count: " + methods.size()));
        }
        Method method = methods.get(0);
        if (!method.isStatic()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Utility method should be static");
        }
        Object result = evaluationContext.computeAndKeep(() -> evaluationContext.getDebugProcess().invokeMethod(evaluationContext, proxyType, method, args, true));
        LOG.info("Memory agent's method \"" + methodName + "\" took " + (System.currentTimeMillis() - start) + " ms");
        return result;
    }

    private static byte @NotNull [] readUtilityClass() {
        return new ProxyExtractor().extractProxy();
    }

    @Nullable
    private static ReferenceType loadUtilityClass(@NotNull EvaluationContextImpl context) throws EvaluateException {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        byte[] bytes = MemoryAgentOperations.readUtilityClass();
        context.setAutoLoadClasses(true);
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(context, debugProcess);
        ClassLoadingUtils.defineClass("com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", bytes, context, debugProcess, classLoader);
        try {
            return debugProcess.loadClass(context, "com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", classLoader);
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Could not load proxy class", (Throwable)e);
        }
    }

    @NotNull
    private static ArrayReference wrapWithArray(@NotNull EvaluationContextImpl context, @NotNull List<ObjectReference> references) throws EvaluateException {
        long start = System.currentTimeMillis();
        ArrayType longArray = (ArrayType)context.getDebugProcess().findClass(context, "java.lang.Object[]", context.getClassLoader());
        ArrayReference instancesArray = longArray.newInstance(references.size());
        try {
            instancesArray.setValues(references);
        }
        catch (ClassNotLoadedException | InvalidTypeException e) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Could not wrap objects with array", (Throwable)e);
        }
        LOG.info("Wrapping values with array took " + (System.currentTimeMillis() - start) + " ms");
        return instancesArray;
    }
}

