/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public abstract class MemoryAgentActionBase
extends DebuggerTreeAction {
    protected final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected void perform(final XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project project = node.getTree().getProject();
        DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess(project);
        final ObjectReference reference = this.getObjectReference(node);
        if (debugProcess == null || reference == null) {
            return;
        }
        SuspendContextImpl suspendContext = debugProcess.getSuspendManager().getPausedContext();
        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                try {
                    MemoryAgentActionBase.this.perform(evaluationContext, reference, node);
                }
                catch (EvaluateException ex) {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(JavaDebuggerBundle.message((String)"action.failed", (Object[])new Object[0]), NotificationType.ERROR);
                }
            }

            @Override
            public void commandCancelled() {
                MemoryAgentActionBase.this.LOG.info("command cancelled");
            }
        });
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (!super.isEnabled(node, e)) {
            return false;
        }
        DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess(node.getTree().getProject());
        if (debugProcess == null || !debugProcess.isEvaluationPossible() || !MemoryAgent.get(debugProcess).capabilities().isLoaded()) {
            e.getPresentation().setVisible(false);
            return false;
        }
        ObjectReference reference = this.getObjectReference(node);
        return reference != null && this.isEnabled(MemoryAgent.get(debugProcess).capabilities());
    }

    protected abstract boolean isEnabled(@NotNull MemoryAgentCapabilities var1);

    protected abstract void perform(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, @NotNull XValueNodeImpl var3) throws EvaluateException;
}

