/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class JavaDebuggerAddExceptionBreakpointFilter
implements JvmExceptionOccurrenceFilter {
    @Nullable
    public Filter.ResultItem applyFilter(@NotNull String exceptionClassName, @NotNull List<PsiClass> classes2, int exceptionStartOffset) {
        return new CreateExceptionBreakpointResult(exceptionStartOffset, exceptionStartOffset + exceptionClassName.length(), exceptionClassName);
    }

    private static class CreateExceptionBreakpointResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final String myExceptionFqn;

        CreateExceptionBreakpointResult(int highlightStartOffset, int highlightEndOffset, String exceptionFqn) {
            super(highlightStartOffset, highlightEndOffset, null);
            this.myExceptionFqn = exceptionFqn;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            PresentationFactory factory = new PresentationFactory((EditorImpl)editor);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText("Create breakpoint")), (event, point) -> {
                ExceptionBreakpoint ebpt;
                Project project = editor.getProject();
                XBreakpoint breakpoint = XDebuggerManager.getInstance((Project)project).getBreakpointManager().getBreakpoints(JavaExceptionBreakpointType.class).stream().filter(b -> Objects.equals(this.myExceptionFqn, ((JavaExceptionBreakpointProperties)b.getProperties()).myQualifiedName)).findFirst().orElse(null);
                if (breakpoint == null && (ebpt = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().addExceptionBreakpoint(this.myExceptionFqn, StringUtil.getPackageName((String)this.myExceptionFqn))) != null) {
                    breakpoint = ebpt.getXBreakpoint();
                }
                if (breakpoint != null) {
                    BreakpointsDialogFactory.getInstance((Project)project).showDialog((Object)breakpoint);
                }
            });
            return new PresentationRenderer(presentation);
        }
    }
}

