/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SwitchEvaluator
implements Evaluator {
    private final Evaluator myExpressionEvaluator;
    private final Evaluator[] myBodyEvaluators;
    private final String myLabelName;

    public SwitchEvaluator(Evaluator expressionEvaluator, Evaluator[] bodyEvaluators, @Nullable String labelName) {
        this.myExpressionEvaluator = expressionEvaluator;
        this.myBodyEvaluators = bodyEvaluators;
        this.myLabelName = labelName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object res;
        block6: {
            Object switchValue = UnBoxingEvaluator.unbox(this.myExpressionEvaluator.evaluate(context), context);
            res = null;
            try {
                boolean caseFound = false;
                for (Evaluator evaluator : this.myBodyEvaluators) {
                    if (caseFound) {
                        res = evaluator.evaluate(context);
                        continue;
                    }
                    Evaluator e = DisableGC.unwrap(evaluator);
                    if (!(e instanceof SwitchCaseEvaluator)) continue;
                    res = ((SwitchCaseEvaluator)e).match(switchValue, context);
                    if (Boolean.TRUE.equals(res)) {
                        caseFound = true;
                        continue;
                    }
                    if (!(res instanceof Value)) continue;
                    return res;
                }
            }
            catch (YieldException e) {
                return e.getValue();
            }
            catch (BreakException e) {
                if (Objects.equals(e.getLabelName(), this.myLabelName)) break block6;
                throw e;
            }
        }
        return res;
    }

    static class YieldException
    extends EvaluateException {
        final Object myValue;

        YieldException(Object value2) {
            super("Yield");
            this.myValue = value2;
        }

        public Object getValue() {
            return this.myValue;
        }
    }

    static class YieldEvaluator
    implements Evaluator {
        @Nullable
        final Evaluator myValueEvaluator;

        YieldEvaluator(@Nullable Evaluator valueEvaluator) {
            this.myValueEvaluator = valueEvaluator;
        }

        @Override
        public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
            Object value2 = this.myValueEvaluator == null ? context.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid() : this.myValueEvaluator.evaluate(context);
            throw new YieldException(value2);
        }
    }

    static class SwitchCaseRuleEvaluator
    extends SwitchCaseEvaluator {
        final Evaluator myBodyEvaluator;

        SwitchCaseRuleEvaluator(List<? extends Evaluator> evaluators, boolean defaultCase, Evaluator bodyEvaluator) {
            super(evaluators, defaultCase);
            this.myBodyEvaluator = bodyEvaluator;
        }

        @Override
        Object match(Object value2, EvaluationContextImpl context) throws EvaluateException {
            Object res = super.match(value2, context);
            if (Boolean.TRUE.equals(res)) {
                return this.myBodyEvaluator.evaluate(context);
            }
            return res;
        }
    }

    static class SwitchCaseEvaluator
    implements Evaluator {
        final List<? extends Evaluator> myEvaluators;
        final boolean myDefaultCase;

        SwitchCaseEvaluator(List<? extends Evaluator> evaluators, boolean defaultCase) {
            this.myEvaluators = evaluators;
            this.myDefaultCase = defaultCase;
        }

        Object match(Object value2, EvaluationContextImpl context) throws EvaluateException {
            if (this.myDefaultCase) {
                return true;
            }
            for (Evaluator evaluator : this.myEvaluators) {
                if (!value2.equals(UnBoxingEvaluator.unbox(evaluator.evaluate(context), context))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
            return null;
        }
    }
}

