/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.debugger.engine.dfaassist.DfaHint;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DebuggerInstructionVisitor
extends StandardInstructionVisitor {
    private final Map<PsiExpression, DfaHint> myHints = new HashMap<PsiExpression, DfaHint>();

    DebuggerInstructionVisitor() {
        super(true);
    }

    private void addHint(@NotNull PsiExpression expression2, @Nullable DfaHint hint) {
        if (hint != null) {
            this.myHints.merge(expression2, hint, DfaHint::merge);
        }
    }

    @Override
    protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
        if (range != null || !DebuggerInstructionVisitor.shouldTrackExpressionValue(expression2)) {
            return;
        }
        DfaHint hint = DfaHint.ANY_VALUE;
        DfType dfType = state.getDfType(value2);
        if (dfType == DfTypes.TRUE) {
            hint = DfaHint.TRUE;
        } else if (dfType == DfTypes.FALSE) {
            hint = DfaHint.FALSE;
        } else if (dfType == DfTypes.FAIL) {
            hint = DfaHint.FAIL;
        }
        this.addHint(expression2, hint);
    }

    @Override
    protected void onTypeCast(PsiTypeCastExpression castExpression, DfaMemoryState state, boolean castPossible) {
        if (!castPossible) {
            this.addHint((PsiExpression)castExpression, DfaHint.CCE);
        }
        super.onTypeCast(castExpression, state, castPossible);
    }

    @Override
    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
        if (alwaysOutOfBounds) {
            this.addHint((PsiExpression)expression2, DfaHint.AIOOBE);
        }
        super.processArrayAccess(expression2, alwaysOutOfBounds);
    }

    @Override
    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
        this.addHint(assignmentExpression.getLExpression(), DfaHint.ASE);
        super.processArrayStoreTypeMismatch(assignmentExpression, fromType, toType);
    }

    @Override
    protected boolean checkNotNullable(DfaMemoryState state, @NotNull DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        PsiExpression expression2;
        if (problem != null && (expression2 = problem.getDereferencedExpression()) != null && problem.thrownException() != null && state.isNull(value2)) {
            DfaHint hint = problem.thrownException().equals("java.lang.NullPointerException") ? DfaHint.NPE : DfaHint.NULL_AS_NOT_NULL;
            this.addHint(expression2, hint);
        }
        return super.checkNotNullable(state, value2, problem);
    }

    private static boolean shouldTrackExpressionValue(@NotNull PsiExpression expr2) {
        IElementType tokenType;
        if (BoolUtils.isNegated(expr2)) {
            return false;
        }
        if (expr2 instanceof PsiAssignmentExpression) {
            return false;
        }
        return !(expr2 instanceof PsiPolyadicExpression) || !(tokenType = ((PsiPolyadicExpression)expr2).getOperationTokenType()).equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR);
    }

    void cleanup() {
        this.myHints.entrySet().removeIf(e -> {
            PsiExpression expr2 = (PsiExpression)e.getKey();
            DfaHint hint = (DfaHint)((Object)((Object)e.getValue()));
            if (hint.getTitle() == null) {
                return true;
            }
            CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expr2);
            return result != null && result.getExpressionValues(expr2).size() == 1;
        });
    }

    @NotNull
    Map<PsiExpression, DfaHint> getHints() {
        return this.myHints;
    }
}

