/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Method;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class SyntheticMethodBreakpoint
extends WildcardMethodBreakpoint {
    private final JavaMethodBreakpointProperties myProperties = new JavaMethodBreakpointProperties();
    private final String mySignature;
    private String mySuspendPolicy;

    public SyntheticMethodBreakpoint(String className2, String methodName, @Nullable String signature, Project project) {
        super(project, (XBreakpoint<JavaMethodBreakpointProperties>)null);
        this.myProperties.EMULATED = true;
        this.myProperties.WATCH_EXIT = false;
        this.myProperties.myClassPattern = className2;
        this.myProperties.myMethodName = methodName;
        this.mySignature = signature;
    }

    @Override
    public StreamEx<Method> matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        String methodName = this.getMethodName();
        return (StreamEx)((StreamEx)methods.filter(m -> Objects.equals(methodName, m.name()) && (this.mySignature == null || Objects.equals(this.mySignature, m.signature())))).limit(1L);
    }

    @Override
    @NotNull
    protected JavaMethodBreakpointProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return false;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return false;
    }

    @Override
    public boolean isConditionEnabled() {
        return false;
    }

    @Override
    public String getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    @Override
    public void setSuspendPolicy(String policy) {
        this.mySuspendPolicy = policy;
    }

    @Override
    protected void fireBreakpointChanged() {
    }

    @Override
    protected boolean isLogEnabled() {
        return false;
    }

    @Override
    protected boolean isLogExpressionEnabled() {
        return false;
    }

    @Override
    protected boolean isLogStack() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }
}

