/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaFramesListRenderer {
    JavaFramesListRenderer() {
    }

    public static void customizePresentation(StackFrameDescriptorImpl descriptor, @NotNull ColoredTextContainer component, @Nullable StackFrameDescriptorImpl selectedDescriptor) {
        String label;
        int openingBrace;
        component.setIcon(descriptor.getIcon());
        ValueMarkup markup = descriptor.getValueMarkup();
        if (markup != null) {
            component.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        int closingBrace = (openingBrace = (label = descriptor.getLabel()).indexOf("{")) < 0 ? -1 : label.indexOf("}");
        SimpleTextAttributes attributes = JavaFramesListRenderer.getAttributes(descriptor);
        if (openingBrace < 0 || closingBrace < 0) {
            component.append(label, attributes);
        } else {
            component.append(label.substring(0, openingBrace - 1), attributes);
            component.append(" (" + label.substring(openingBrace + 1, closingBrace) + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            component.append(label.substring(closingBrace + 1), attributes);
        }
        if (JavaFramesListRenderer.isOccurrenceOfSelectedFrame(selectedDescriptor, descriptor) && descriptor.isRecursiveCall()) {
            component.append(" [" + descriptor.getOccurrenceIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private static boolean isOccurrenceOfSelectedFrame(@Nullable StackFrameDescriptorImpl selectedDescriptor, @NotNull StackFrameDescriptorImpl descriptor) {
        Method method = descriptor.getMethod();
        return selectedDescriptor != null && method != null && method.equals(selectedDescriptor.getMethod());
    }

    private static SimpleTextAttributes getAttributes(StackFrameDescriptorImpl descriptor) {
        if (descriptor.isSynthetic() || descriptor.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }
}

