/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Range;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaSmartStepTarget
extends SmartStepTarget {
    private final PsiLambdaExpression myLambda;
    private final int myOrdinal;
    private final boolean myAsync;

    public LambdaSmartStepTarget(@NotNull PsiLambdaExpression lambda2, @Nullable String label, @Nullable PsiElement highlightElement, int ordinal, Range<Integer> lines, boolean async) {
        super(label, highlightElement, true, lines);
        this.myLambda = lambda2;
        this.myOrdinal = ordinal;
        this.myAsync = async;
    }

    public PsiLambdaExpression getLambda() {
        return this.myLambda;
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public boolean isAsync() {
        return this.myAsync;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myLambda.getIcon(0);
    }

    @Override
    @NotNull
    public String getPresentation() {
        String typeText = PsiFormatUtil.formatType((PsiType)this.myLambda.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String label = this.getLabel();
        return label != null ? label + typeText : typeText;
    }
}

