/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReferringObjectsValue
extends JavaValue {
    private static final long MAX_REFERRING = 100L;
    private final ReferringObjectsProvider myReferringObjectsProvider;
    private final Function<? super XValueNode, ? extends XValueNode> myNodeConfigurator;

    private JavaReferringObjectsValue(@Nullable JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, @NotNull ReferringObjectsProvider referringObjectsProvider, NodeManagerImpl nodeManager, @Nullable Function<? super XValueNode, ? extends XValueNode> nodeConfigurator) {
        super(parent, valueDescriptor, evaluationContext, nodeManager, false);
        this.myReferringObjectsProvider = referringObjectsProvider;
        this.myNodeConfigurator = nodeConfigurator;
    }

    public JavaReferringObjectsValue(@NotNull JavaValue javaValue, @NotNull ReferringObjectsProvider referringObjectsProvider, @Nullable Function<? super XValueNode, ? extends XValueNode> nodeConfigurator) {
        super(null, javaValue.getName(), javaValue.getDescriptor(), javaValue.getEvaluationContext(), javaValue.getNodeManager(), false);
        this.myReferringObjectsProvider = referringObjectsProvider;
        this.myNodeConfigurator = nodeConfigurator;
    }

    @Override
    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                return new JavaReferringObjectsValue(JavaReferringObjectsValue.this, JavaReferringObjectsValue.this.myReferringObjectsProvider, null);
            }
        };
    }

    @Override
    public void computeChildren(final @NotNull XCompositeNode node) {
        JavaReferringObjectsValue.scheduleCommand(this.getEvaluationContext(), node, new SuspendContextCommandImpl(this.getEvaluationContext().getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                List<ReferringObject> referringObjects;
                XValueChildrenList children = new XValueChildrenList();
                Value value2 = JavaReferringObjectsValue.this.getDescriptor().getValue();
                try {
                    referringObjects = JavaReferringObjectsValue.this.myReferringObjectsProvider.getReferringObjects(JavaReferringObjectsValue.this.getEvaluationContext(), (ObjectReference)value2, 100L);
                }
                catch (ObjectCollectedException e) {
                    node.setErrorMessage(JavaDebuggerBundle.message((String)"evaluation.error.object.collected", (Object[])new Object[0]));
                    return;
                }
                catch (EvaluateException e) {
                    node.setErrorMessage(e.getMessage());
                    return;
                }
                int i = 1;
                for (ReferringObject object : referringObjects) {
                    String nodeName = object.getNodeName(i++);
                    ValueDescriptorImpl descriptor = object.createValueDescription(JavaReferringObjectsValue.this.getProject(), value2);
                    JavaReferringObjectsValue referringValue = new JavaReferringObjectsValue(null, descriptor, JavaReferringObjectsValue.this.getEvaluationContext(), JavaReferringObjectsValue.this.myReferringObjectsProvider, JavaReferringObjectsValue.this.getNodeManager(), object.getNodeCustomizer());
                    if (nodeName == null) {
                        children.add((XNamedValue)referringValue);
                        continue;
                    }
                    children.add(nodeName, (XValue)referringValue);
                }
                node.addChildren(children, true);
            }
        });
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        super.computePresentation(this.myNodeConfigurator == null ? node : this.myNodeConfigurator.apply((XValueNode)node), place);
    }

    @Override
    @Nullable
    public XValueModifier getModifier() {
        return null;
    }
}

