/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapUIImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class HotSwapAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
        DebuggerSession session = debuggerManager.getContext().getDebuggerSession();
        if (session != null && session.isAttached()) {
            HotSwapUI.getInstance(project).reloadChangedClasses(session, DebuggerSettings.getInstance().COMPILE_BEFORE_HOTSWAP);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
        DebuggerSession session = debuggerManager.getContext().getDebuggerSession();
        e.getPresentation().setEnabled(session != null && HotSwapUIImpl.canHotSwap(session));
    }
}

