/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.compiler.impl.CompilerErrorTreeView;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.progress.BuildViewService;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompilerMessagesService
implements BuildViewService {
    private static final Logger LOG = Logger.getInstance(CompilerTask.class);
    private static final Key<Object> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    private static final Key<Object> SESSION_ID_KEY = Key.create((String)"SESSION_ID");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myContentId;
    private String myContentName;
    private Runnable myRestartWork;
    private final boolean myHeadlessMode;
    private boolean myMessagesAutoActivated = false;
    private final Object myMessageViewLock = new Object();
    private final AtomicBoolean myMessageViewWasPrepared = new AtomicBoolean(false);
    private volatile ProgressIndicator myIndicator = new EmptyProgressIndicator();
    private NewErrorTreeViewPanel myErrorTreeView;
    private CloseListener myCloseListener;

    public CompilerMessagesService(@NotNull Project project, @NotNull Object contentId, String contentName, boolean headlessMode) {
        this.myProject = project;
        this.myContentId = contentId;
        this.myContentName = contentName;
        this.myHeadlessMode = headlessMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCloseAction(final Runnable onClose) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                Disposer.register((Disposable)this.myErrorTreeView, (Disposable)new Disposable(){

                    public void dispose() {
                        onClose.run();
                    }
                });
                return;
            }
        }
        onClose.run();
    }

    @Override
    public void onProgressChange(Object sessionId, ProgressIndicator indicator) {
        this.prepareMessageView(sessionId, indicator);
    }

    @Override
    public void addMessage(Object sessionId, CompilerMessage message2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.openMessageView(sessionId);
            this.doAddMessage(message2);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    this.openMessageView(sessionId);
                    this.doAddMessage(message2);
                }
            }, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart(Object sessionId, long startCompilationStamp, Runnable restartWork, ProgressIndicator indicator) {
        this.myCloseListener = new CloseListener();
        Object object = this.myMessageViewLock;
        synchronized (object) {
            this.myRestartWork = restartWork;
        }
        this.myIndicator = indicator;
        if (!this.isHeadlessMode()) {
            this.addIndicatorDelegate(this.myIndicator);
        }
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
    }

    private void addIndicatorDelegate(ProgressIndicator indicator) {
        if (!(indicator instanceof ProgressIndicatorEx)) {
            return;
        }
        ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new DummyProgressIndicator(){

            @Override
            public void cancel() {
                CompilerMessagesService.this.selectFirstMessage();
            }

            @Override
            public void stop() {
                if (!this.isCanceled()) {
                    CompilerMessagesService.this.selectFirstMessage();
                }
            }
        });
    }

    @Override
    public void onEnd(Object sessionId, ExitStatus exitStatus, long endCompilationStamp) {
        ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
        this.cleanupMessageViewIfEmpty(sessionId);
    }

    public static boolean showCompilerContent(Project project, Object contentId) {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
        for (Content content : messageView.getContentManager().getContents()) {
            if (CONTENT_ID_KEY.get((UserDataHolder)content) != contentId) continue;
            messageView.getContentManager().setSelectedContent(content);
            return true;
        }
        return false;
    }

    private void selectFirstMessage() {
        if (!this.isHeadlessMode()) {
            SwingUtilities.invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                Object object = this.myMessageViewLock;
                synchronized (object) {
                    if (this.myErrorTreeView != null) {
                        this.myErrorTreeView.selectFirstMessage();
                    }
                }
            });
        }
    }

    private boolean isHeadlessMode() {
        return this.myHeadlessMode;
    }

    public static int translateCategory(CompilerMessageCategory category) {
        if (CompilerMessageCategory.ERROR.equals((Object)category)) {
            return 4;
        }
        if (CompilerMessageCategory.WARNING.equals((Object)category)) {
            return 5;
        }
        if (CompilerMessageCategory.STATISTICS.equals((Object)category)) {
            return 2;
        }
        if (CompilerMessageCategory.INFORMATION.equals((Object)category)) {
            return 3;
        }
        LOG.error("Unknown message category: " + category);
        return 0;
    }

    private void prepareMessageView(Object sessionId, ProgressIndicator indicator) {
        if (indicator.isRunning() && !this.myMessageViewWasPrepared.getAndSet(true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = this.myProject;
                if (!project.isDisposed()) {
                    Object object = this.myMessageViewLock;
                    synchronized (object) {
                        MessageView messageView;
                        if (this.myErrorTreeView == null && (messageView = (MessageView)project.getServiceIfCreated(MessageView.class)) != null && messageView.getContentManager().getContentCount() > 0) {
                            this.openMessageView(sessionId);
                        }
                    }
                }
            });
        }
    }

    private void cleanupMessageViewIfEmpty(Object sessionId) {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.myProject;
            if (!project.isDisposed()) {
                Object object = this.myMessageViewLock;
                synchronized (object) {
                    ToolWindow tw;
                    NewErrorTreeViewPanel errorTreeView = this.myErrorTreeView;
                    if (errorTreeView != null && errorTreeView.getErrorViewStructure().isEmpty() && ((tw = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages")) == null || !tw.isVisible())) {
                        this.removeTaskContents(project, sessionId);
                    }
                }
            }
        });
    }

    private void removeTaskContents(Project project, Object sessionId) {
        if (project.isDisposed()) {
            return;
        }
        ContentManager contentManager = MessageView.SERVICE.getInstance((Project)project).getContentManager();
        for (Content content : contentManager.getContents()) {
            if (content.isPinned() || CONTENT_ID_KEY.get((UserDataHolder)content) != this.myContentId && SESSION_ID_KEY.get((UserDataHolder)content) != sessionId) continue;
            contentManager.removeContent(content, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMessageView(Object sessionId) {
        JComponent component;
        if (this.isHeadlessMode() || this.myIndicator.isCanceled()) {
            return;
        }
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                return;
            }
            this.myErrorTreeView = new CompilerErrorTreeView(this.myProject, this.myRestartWork);
            this.myErrorTreeView.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

                public void stopProcess() {
                    if (!CompilerMessagesService.this.myIndicator.isCanceled()) {
                        CompilerMessagesService.this.myIndicator.cancel();
                    }
                }

                public boolean isProcessStopped() {
                    return !CompilerMessagesService.this.myIndicator.isRunning();
                }
            });
            component = this.myErrorTreeView.getComponent();
        }
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
        messageView.runWhenInitialized(() -> {
            Content content = ContentFactory.SERVICE.getInstance().createContent(component, this.myContentName, true);
            content.setHelpId("reference.toolWindows.messages");
            CONTENT_ID_KEY.set((UserDataHolder)content, this.myContentId);
            SESSION_ID_KEY.set((UserDataHolder)content, sessionId);
            messageView.getContentManager().addContent(content);
            this.myCloseListener.setContent(content, messageView.getContentManager());
            this.removeOldContents(this.myProject, sessionId, content);
            messageView.getContentManager().setSelectedContent(content);
        });
    }

    private void removeOldContents(Project project, Object sessionId, Content notRemove) {
        if (project.isDisposed()) {
            return;
        }
        ContentManager contentManager = MessageView.SERVICE.getInstance((Project)project).getContentManager();
        for (Content content : contentManager.getContents()) {
            boolean toRemove2;
            if (content.isPinned() || content == notRemove) continue;
            boolean bl = toRemove2 = CONTENT_ID_KEY.get((UserDataHolder)content) == this.myContentId;
            if (!toRemove2) {
                Object contentSessionId = SESSION_ID_KEY.get((UserDataHolder)content);
                boolean bl2 = toRemove2 = contentSessionId != null && contentSessionId != sessionId;
            }
            if (!toRemove2) continue;
            contentManager.removeContent(content, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMessageView() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            ToolWindow tw;
            if (this.myErrorTreeView != null && (tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages")) != null) {
                tw.activate(null, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddMessage(CompilerMessage message2) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                boolean shouldAutoActivate;
                Navigatable navigatable = message2.getNavigatable();
                VirtualFile file = message2.getVirtualFile();
                CompilerMessageCategory category = message2.getCategory();
                int type2 = CompilerMessagesService.translateCategory(category);
                String[] text2 = CompilerMessagesService.convertMessage(message2);
                if (navigatable != null) {
                    String groupName = file != null ? file.getPresentableUrl() : category.getPresentableText();
                    this.myErrorTreeView.addMessage(type2, text2, groupName, navigatable, message2.getExportTextPrefix(), message2.getRenderTextPrefix(), (Object)message2.getVirtualFile());
                } else {
                    this.myErrorTreeView.addMessage(type2, text2, file, -1, -1, (Object)message2.getVirtualFile());
                }
                boolean bl = shouldAutoActivate = !this.myMessagesAutoActivated && (CompilerMessageCategory.ERROR.equals((Object)category) || CompilerMessageCategory.WARNING.equals((Object)category) && !ErrorTreeViewConfiguration.getInstance((Project)this.myProject).isHideWarnings());
                if (shouldAutoActivate) {
                    this.myMessagesAutoActivated = true;
                    this.activateMessageView();
                }
            }
        }
    }

    private static String[] convertMessage(CompilerMessage message2) {
        String text2 = message2.getMessage();
        if (!text2.contains("\n")) {
            return new String[]{text2};
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text2, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return ArrayUtilRt.toStringArray(lines);
    }

    static class DummyProgressIndicator
    implements ProgressIndicatorEx {
        DummyProgressIndicator() {
        }

        public void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        }

        public void finish(@NotNull TaskInfo task) {
        }

        public boolean isFinished(@NotNull TaskInfo task) {
            return false;
        }

        public boolean wasStarted() {
            return false;
        }

        public void processFinish() {
        }

        public void initStateFrom(@NotNull ProgressIndicator indicator) {
        }

        public void start() {
        }

        public void stop() {
        }

        public boolean isRunning() {
            return false;
        }

        public void cancel() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setText(@Nls(capitalization=Nls.Capitalization.Sentence) String text2) {
        }

        public String getText() {
            return null;
        }

        public void setText2(@Nls(capitalization=Nls.Capitalization.Sentence) String text2) {
        }

        public String getText2() {
            return null;
        }

        public double getFraction() {
            return 0.0;
        }

        public void setFraction(double fraction) {
        }

        public void pushState() {
        }

        public void popState() {
        }

        public boolean isModal() {
            return false;
        }

        @NotNull
        public ModalityState getModalityState() {
            return ModalityState.defaultModalityState();
        }

        public void setModalityProgress(@Nullable ProgressIndicator modalityProgress) {
        }

        public boolean isIndeterminate() {
            return false;
        }

        public void setIndeterminate(boolean indeterminate) {
        }

        public void checkCanceled() throws ProcessCanceledException {
        }

        public boolean isPopupWasShown() {
            return false;
        }

        public boolean isShowing() {
            return false;
        }
    }

    private final class CloseListener
    implements ProjectManagerListener,
    ContentManagerListener {
        private Content myContent;
        private ContentManager myContentManager;
        private boolean myIsApplicationExitingOrProjectClosing = false;
        private boolean myUserAcceptedCancel = false;

        private CloseListener() {
        }

        public void projectClosingBeforeSave(@NotNull Project project) {
            if (CompilerMessagesService.this.myProject == project && !CompilerMessagesService.this.myIndicator.isCanceled()) {
                CompilerMessagesService.this.myIndicator.cancel();
            }
        }

        public void setContent(Content content, ContentManager contentManager) {
            this.myContent = content;
            this.myContentManager = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                Object object = CompilerMessagesService.this.myMessageViewLock;
                synchronized (object) {
                    if (CompilerMessagesService.this.myErrorTreeView != null) {
                        Disposer.dispose((Disposable)CompilerMessagesService.this.myErrorTreeView);
                        CompilerMessagesService.this.myErrorTreeView = null;
                        if (CompilerMessagesService.this.myIndicator.isRunning() && !CompilerMessagesService.this.myIndicator.isCanceled()) {
                            CompilerMessagesService.this.myIndicator.cancel();
                        }
                        if (AppIcon.getInstance().hideProgress(CompilerMessagesService.this.myProject, (Object)"compiler")) {
                            AppIcon.getInstance().setErrorBadge(CompilerMessagesService.this.myProject, null);
                        }
                    }
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event.getContent() == this.myContent && !CompilerMessagesService.this.myIndicator.isCanceled() && this.shouldAskUser()) {
                int result = Messages.showOkCancelDialog((Project)CompilerMessagesService.this.myProject, (String)JavaCompilerBundle.message((String)"warning.compiler.running.on.toolwindow.close", (Object[])new Object[0]), (String)JavaCompilerBundle.message((String)"compiler.running.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    event.consume();
                }
                this.myUserAcceptedCancel = true;
            }
        }

        private boolean shouldAskUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && CompilerMessagesService.this.myIndicator.isRunning();
        }

        public void projectClosed(@NotNull Project project) {
            if (project.equals(CompilerMessagesService.this.myProject) && this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(@NotNull Project project) {
            if (project.equals(CompilerMessagesService.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }
    }
}

