/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    private static final Logger LOG = Logger.getInstance(CompilerUtil.class);

    public static String quotePath(String path) {
        if (path != null && path.indexOf(32) != -1) {
            path = path.replaceAll("\\\\", "\\\\\\\\");
            path = '\"' + path + '\"';
        }
        return path;
    }

    public static void refreshIOFiles(@NotNull Collection<? extends File> files) {
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files);
        }
    }

    public static void refreshIODirectories(@NotNull Collection<? extends File> files) {
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files, false, true, null);
        }
    }

    public static void refreshOutputRoots(@NotNull Collection<String> outputRoots) {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>();
        for (String outputRoot : outputRoots) {
            FileAttributes attributes = FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)outputRoot));
            VirtualFile vFile = fs.findFileByPath(outputRoot);
            if (attributes != null && vFile == null) {
                VirtualFile parent = fs.refreshAndFindFileByPath(PathUtil.getParentPath((String)outputRoot));
                if (parent == null || !toRefresh.add(parent)) continue;
                parent.getChildren();
                continue;
            }
            if ((attributes != null || vFile == null) && (attributes == null || attributes.isDirectory() == vFile.isDirectory())) continue;
            toRefresh.add(vFile);
        }
        if (!toRefresh.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, toRefresh);
        }
    }

    public static void refreshIOFile(File file) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runInContext(CompileContext context, String title, ThrowableRunnable<T> action) throws T {
        ProgressIndicator indicator = context.getProgressIndicator();
        if (title != null) {
            indicator.pushState();
            indicator.setText(title);
        }
        try {
            action.run();
        }
        finally {
            if (title != null) {
                indicator.popState();
            }
        }
    }

    public static void logDuration(String activityName, long duration) {
        LOG.info(activityName + " took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }
}

