/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.xml;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeprecatedClassUsageInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (tag.getValue().getTextElements().length > 0) {
                    DeprecatedClassUsageInspection.checkReferences((PsiElement)tag, holder);
                }
            }

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                DeprecatedClassUsageInspection.checkReferences((PsiElement)value2, holder);
            }
        };
    }

    private static void checkReferences(PsiElement psiElement, ProblemsHolder holder) {
        PsiElement resolved;
        Object[] references = psiElement.getReferences();
        PsiReference last = (PsiReference)ArrayUtil.getLastElement((Object[])references);
        if (last != null && (!(last instanceof ResolvingHint) || ((ResolvingHint)last).canResolveTo(PsiDocCommentOwner.class)) && (resolved = last.resolve()) instanceof PsiModifierListOwner) {
            DeprecationInspectionBase.checkDeprecated((PsiModifierListOwner)resolved, psiElement, last.getRangeInElement(), false, false, true, false, holder, false, ProblemHighlightType.LIKE_DEPRECATED);
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return JavaAnalysisBundle.message((String)"deprecated.class.usage.group.xml", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "DeprecatedClassUsageInspection";
    }
}

