/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedSymbol;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiModifier;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedSymbolLocalInspectionBase
extends AbstractBaseJavaLocalInspectionTool
implements UnfairLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "unused";
    @NonNls
    public static final String UNUSED_PARAMETERS_SHORT_NAME = "UnusedParameters";
    @NonNls
    public static final String UNUSED_ID = "unused";
    public boolean LOCAL_VARIABLE = true;
    public boolean FIELD = true;
    public boolean METHOD = true;
    public boolean CLASS = true;
    protected boolean INNER_CLASS = true;
    public boolean PARAMETER = true;
    public boolean REPORT_PARAMETER_FOR_PUBLIC_METHODS = true;
    protected String myClassVisibility = "public";
    protected String myInnerClassVisibility = "public";
    protected String myFieldVisibility = "public";
    protected String myMethodVisibility = "public";
    protected String myParameterVisibility = "public";
    private boolean myIgnoreAccessors = false;

    @PsiModifier.ModifierConstant
    @Nullable
    public String getClassVisibility() {
        if (!this.CLASS) {
            return null;
        }
        return this.myClassVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getFieldVisibility() {
        if (!this.FIELD) {
            return null;
        }
        return this.myFieldVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getMethodVisibility() {
        if (!this.METHOD) {
            return null;
        }
        return this.myMethodVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getParameterVisibility() {
        if (!this.PARAMETER) {
            return null;
        }
        return this.myParameterVisibility;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    public String getInnerClassVisibility() {
        if (!this.INNER_CLASS) {
            return null;
        }
        return this.myInnerClassVisibility;
    }

    public void setInnerClassVisibility(String innerClassVisibility) {
        this.myInnerClassVisibility = innerClassVisibility;
    }

    public void setClassVisibility(String classVisibility) {
        this.myClassVisibility = classVisibility;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.myFieldVisibility = fieldVisibility;
    }

    public void setMethodVisibility(String methodVisibility) {
        this.myMethodVisibility = methodVisibility;
    }

    public void setParameterVisibility(String parameterVisibility) {
        this.REPORT_PARAMETER_FOR_PUBLIC_METHODS = "public".equals(parameterVisibility);
        this.myParameterVisibility = parameterVisibility;
    }

    public boolean isIgnoreAccessors() {
        return this.myIgnoreAccessors;
    }

    public void setIgnoreAccessors(boolean ignoreAccessors) {
        this.myIgnoreAccessors = ignoreAccessors;
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "unused";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        return "unused";
    }

    public String getAlternativeID() {
        return "UnusedDeclaration";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        UnusedSymbolLocalInspectionBase.writeVisibility(node, this.myClassVisibility, "klass");
        UnusedSymbolLocalInspectionBase.writeVisibility(node, this.myInnerClassVisibility, "inner_class");
        UnusedSymbolLocalInspectionBase.writeVisibility(node, this.myFieldVisibility, "field");
        UnusedSymbolLocalInspectionBase.writeVisibility(node, this.myMethodVisibility, "method");
        UnusedSymbolLocalInspectionBase.writeVisibility(node, "parameter", this.myParameterVisibility, this.getParameterDefaultVisibility());
        if (this.myIgnoreAccessors) {
            node.setAttribute("ignoreAccessors", Boolean.toString(true));
        }
        if (!this.INNER_CLASS) {
            node.setAttribute("INNER_CLASS", Boolean.toString(false));
        }
        super.writeSettings(node);
    }

    private static void writeVisibility(Element node, String visibility, String type2) {
        UnusedSymbolLocalInspectionBase.writeVisibility(node, type2, visibility, "public");
    }

    private static void writeVisibility(Element node, String type2, String visibility, String defaultVisibility) {
        if (!defaultVisibility.equals(visibility)) {
            node.setAttribute(type2, visibility);
        }
    }

    private String getParameterDefaultVisibility() {
        return this.REPORT_PARAMETER_FOR_PUBLIC_METHODS ? "public" : "private";
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        this.myClassVisibility = UnusedSymbolLocalInspectionBase.readVisibility(node, "klass");
        this.myInnerClassVisibility = UnusedSymbolLocalInspectionBase.readVisibility(node, "inner_class");
        this.myFieldVisibility = UnusedSymbolLocalInspectionBase.readVisibility(node, "field");
        this.myMethodVisibility = UnusedSymbolLocalInspectionBase.readVisibility(node, "method");
        this.myParameterVisibility = UnusedSymbolLocalInspectionBase.readVisibility(node, "parameter", this.getParameterDefaultVisibility());
        String ignoreAccessors = node.getAttributeValue("ignoreAccessors");
        this.myIgnoreAccessors = ignoreAccessors != null && Boolean.parseBoolean(ignoreAccessors);
        String innerClassEnabled = node.getAttributeValue("INNER_CLASS");
        this.INNER_CLASS = innerClassEnabled == null || Boolean.parseBoolean(innerClassEnabled);
    }

    private static String readVisibility(@NotNull Element node, String type2) {
        return UnusedSymbolLocalInspectionBase.readVisibility(node, type2, "public");
    }

    private static String readVisibility(@NotNull Element node, String type2, String defaultVisibility) {
        String visibility = node.getAttributeValue(type2);
        if (visibility == null) {
            return defaultVisibility;
        }
        return visibility;
    }
}

