/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unusedImport.ImportsAreUsedVisitor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedImportInspection
extends GlobalSimpleInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNUSED_IMPORT";

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (!(file instanceof PsiJavaFile) || FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        ImportsAreUsedVisitor visitor2 = new ImportsAreUsedVisitor(javaFile);
        javaFile.accept((PsiElementVisitor)visitor2);
        for (PsiImportStatementBase unusedImportStatement : visitor2.getUnusedImportStatements()) {
            PsiJavaCodeReferenceElement reference = unusedImportStatement.getImportReference();
            if (reference == null || reference.multiResolve(false).length <= 0 || PsiTreeUtil.skipWhitespacesForward((PsiElement)unusedImportStatement) instanceof PsiErrorElement) continue;
            problemsHolder.registerProblem((PsiElement)unusedImportStatement, InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]), new LocalQuickFix[]{new DeleteImportFix()});
        }
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean worksInBatchModeOnly() {
        return false;
    }

    public static String getDisplayNameText() {
        return JavaAnalysisBundle.message((String)"unused.import.display.name", (Object[])new Object[0]);
    }
}

