/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpecialFirstIterationLoop {
    @NotNull
    private final List<PsiStatement> myFirstIterationStatements;
    @NotNull
    private final List<PsiStatement> myOtherIterationStatements;
    @Nullable
    private final PsiLocalVariable myVariable;

    SpecialFirstIterationLoop(@NotNull List<PsiStatement> firstIterationStatements, @NotNull List<PsiStatement> otherIterationStatements, @Nullable PsiLocalVariable variable) {
        this.myFirstIterationStatements = firstIterationStatements;
        this.myOtherIterationStatements = otherIterationStatements;
        this.myVariable = variable;
    }

    @NotNull
    public List<PsiStatement> getOtherIterationStatements() {
        return this.myOtherIterationStatements;
    }

    @NotNull
    public List<PsiStatement> getFirstIterationStatements() {
        return this.myFirstIterationStatements;
    }

    @Nullable
    public PsiLocalVariable getVariable() {
        return this.myVariable;
    }

    @Contract(value="null -> null")
    @Nullable
    static PsiExpression getExpressionComparedToZero(@Nullable PsiBinaryExpression condition2) {
        if (condition2 == null) {
            return null;
        }
        IElementType tokenType = condition2.getOperationTokenType();
        PsiExpression left = condition2.getLOperand();
        PsiExpression right = condition2.getROperand();
        if (ExpressionUtils.isZero(right)) {
            if (tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.GT)) {
                return left;
            }
        } else if (ExpressionUtils.isZero(left) && (tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.LT))) {
            return right;
        }
        return null;
    }

    @Nullable
    private static SpecialFirstIterationLoop extract(boolean firstIterationThen, int index, @NotNull List<PsiStatement> statements, @NotNull PsiLocalVariable checkVar) {
        PsiStatement statement = statements.get(index);
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
        if (ifStatement == null) {
            return null;
        }
        List<PsiStatement> thenStatements = SpecialFirstIterationLoop.unwrapBlock(ifStatement.getThenBranch());
        List<PsiStatement> elseStatements = SpecialFirstIterationLoop.unwrapBlock(ifStatement.getElseBranch());
        return SpecialFirstIterationLoop.extract(firstIterationThen, index, thenStatements, elseStatements, statements, checkVar);
    }

    @Nullable
    private static SpecialFirstIterationLoop extract(boolean firstIterationThen, int index, @NotNull List<PsiStatement> thenStatements, @NotNull List<PsiStatement> elseStatements, @NotNull List<PsiStatement> statements, @NotNull PsiLocalVariable checkVar) {
        PsiStatement statement = statements.get(index);
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
        if (ifStatement == null) {
            return null;
        }
        List<PsiStatement> beforeStatements = statements.subList(0, index);
        List<PsiStatement> afterStatements = statements.subList(index + 1, statements.size());
        ArrayList<PsiStatement> firstIteration = new ArrayList<PsiStatement>(beforeStatements);
        ArrayList<PsiStatement> otherIterations = new ArrayList<PsiStatement>(beforeStatements);
        firstIteration.addAll(firstIterationThen ? thenStatements : elseStatements);
        firstIteration.addAll(afterStatements);
        otherIterations.addAll(firstIterationThen ? elseStatements : thenStatements);
        otherIterations.addAll(afterStatements);
        return new SpecialFirstIterationLoop(firstIteration, otherIterations, checkVar);
    }

    private static int getSingleStatementIndex(@NotNull List<PsiStatement> statements, @NotNull Predicate<PsiStatement> predicate) {
        int index = -1;
        for (int i = 0; i < statements.size(); ++i) {
            PsiStatement statement = statements.get(i);
            if (!predicate.test(statement)) continue;
            if (index != -1) {
                return -1;
            }
            index = i;
        }
        return index;
    }

    private static int getSingleAssignmentIndex(@NotNull List<PsiStatement> statements) {
        return SpecialFirstIterationLoop.getSingleStatementIndex(statements, statement -> ExpressionUtils.getAssignment((PsiElement)statement) != null);
    }

    @NotNull
    private static List<PsiStatement> unwrapBlock(@Nullable PsiStatement statement) {
        if (statement == null) {
            return Collections.emptyList();
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)statement, PsiBlockStatement.class);
        if (blockStatement == null) {
            return Collections.singletonList(statement);
        }
        return ContainerUtil.newArrayList((Object[])blockStatement.getCodeBlock().getStatements());
    }

    static class IndexBasedLoop {
        private IndexBasedLoop() {
        }

        @Nullable
        static SpecialFirstIterationLoop extract(@NotNull TerminalBlock terminalBlock, StreamApiMigrationInspection.CountingLoopSource countingLoopSource) {
            PsiVariable loopVar = countingLoopSource.getVariable();
            PsiLocalVariable loopLocalVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)loopVar, PsiLocalVariable.class);
            if (loopLocalVar == null) {
                return null;
            }
            ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
            int index = SpecialFirstIterationLoop.getSingleStatementIndex(statements, statement -> statement instanceof PsiIfStatement);
            if (index == -1) {
                return null;
            }
            ThreeState firstIterationThen = IndexBasedLoop.isFirstIterationThen((PsiStatement)statements.get(index), loopVar);
            if (firstIterationThen.equals((Object)ThreeState.UNSURE)) {
                return null;
            }
            return SpecialFirstIterationLoop.extract(firstIterationThen.toBoolean(), index, statements, loopLocalVar);
        }

        @NotNull
        private static ThreeState isFirstIterationThen(@NotNull PsiStatement statement, @NotNull PsiVariable loopVar) {
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return ThreeState.UNSURE;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return ThreeState.UNSURE;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition2, PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return ThreeState.UNSURE;
            }
            PsiExpression comparedEqWithZero = ExpressionUtils.getValueComparedWithZero(binaryExpression);
            if (comparedEqWithZero != null) {
                if (!ExpressionUtils.isReferenceTo(comparedEqWithZero, loopVar)) {
                    return ThreeState.UNSURE;
                }
                return ThreeState.YES;
            }
            PsiExpression notEqWithZero = SpecialFirstIterationLoop.getExpressionComparedToZero(binaryExpression);
            if (notEqWithZero == null || !ExpressionUtils.isReferenceTo(notEqWithZero, loopVar)) {
                return ThreeState.UNSURE;
            }
            return ThreeState.NO;
        }
    }

    static class BoolFlagLoop {
        private BoolFlagLoop() {
        }

        @Nullable
        static SpecialFirstIterationLoop extract(TerminalBlock terminalBlock) {
            ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
            int index = SpecialFirstIterationLoop.getSingleStatementIndex(statements, PsiIfStatement.class::isInstance);
            if (index == -1) {
                return null;
            }
            PsiStatement statement = (PsiStatement)statements.get(index);
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return null;
            }
            ThreeState firstIterationThen = BoolFlagLoop.isFirstIterationThen(statement);
            if (firstIterationThen.equals((Object)ThreeState.UNSURE)) {
                return null;
            }
            ConditionData conditionData = ConditionData.extract(ifStatement, firstIterationThen.toBoolean());
            if (conditionData == null) {
                return null;
            }
            PsiAssignmentExpression assignment = conditionData.getAssignment();
            PsiExpression expression2 = assignment.getLExpression();
            PsiLocalVariable boolFlag = ExpressionUtils.resolveLocalVariable(expression2);
            if (boolFlag == null) {
                return null;
            }
            PsiExpression rExpression = assignment.getRExpression();
            if (rExpression == null) {
                return null;
            }
            if (!BoolFlagLoop.assignmentNegatesInitializer((PsiVariable)boolFlag, rExpression)) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            boolean referencesAllowed = ReferencesSearch.search((PsiElement)boolFlag).forEach(reference -> PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)assignment, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)boolFlag, (PsiElement)reference.getElement(), (boolean)false));
            if (!referencesAllowed) {
                return null;
            }
            return SpecialFirstIterationLoop.extract(firstIterationThen.toBoolean(), index, conditionData.getThenStatements(), conditionData.getElseStatements(), statements, boolFlag);
        }

        private static boolean assignmentNegatesInitializer(@NotNull PsiVariable boolFlag, @NotNull PsiExpression expression2) {
            Object constantExpression = ExpressionUtils.computeConstantExpression(expression2);
            if (!(constantExpression instanceof Boolean)) {
                return false;
            }
            boolean assignmentValue = (Boolean)constantExpression;
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)boolFlag.getInitializer()), !assignmentValue);
        }

        @NotNull
        private static ThreeState isFirstIterationThen(@NotNull PsiStatement statement) {
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return ThreeState.UNSURE;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return ThreeState.UNSURE;
            }
            boolean negated = BoolUtils.isNegation(condition2);
            condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2);
            PsiExpression expression2 = negated ? BoolUtils.getNegated(condition2) : condition2;
            PsiLocalVariable boolFlagVar = ExpressionUtils.resolveLocalVariable(expression2);
            if (boolFlagVar == null) {
                return ThreeState.UNSURE;
            }
            return ThreeState.fromBoolean((boolean)ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)boolFlagVar.getInitializer()), !negated));
        }

        private static class ConditionData {
            @NotNull
            private final List<PsiStatement> myThenStatements;
            @NotNull
            private final List<PsiStatement> myElseStatements;
            @NotNull
            private final PsiAssignmentExpression myAssignment;

            private ConditionData(@NotNull List<PsiStatement> thenStatements, @NotNull List<PsiStatement> elseStatements, @NotNull PsiAssignmentExpression assignment) {
                this.myThenStatements = thenStatements;
                this.myElseStatements = elseStatements;
                this.myAssignment = assignment;
            }

            @NotNull
            public PsiAssignmentExpression getAssignment() {
                return this.myAssignment;
            }

            @NotNull
            public List<PsiStatement> getElseStatements() {
                return this.myElseStatements;
            }

            @NotNull
            public List<PsiStatement> getThenStatements() {
                return this.myThenStatements;
            }

            @Nullable
            static ConditionData extract(@NotNull PsiIfStatement ifStatement, boolean firstIterationThen) {
                PsiStatement block = firstIterationThen ? ifStatement.getThenBranch() : ifStatement.getElseBranch();
                ArrayList<PsiStatement> firstIterationStatements = new ArrayList<PsiStatement>(SpecialFirstIterationLoop.unwrapBlock(block));
                int index = SpecialFirstIterationLoop.getSingleAssignmentIndex(firstIterationStatements);
                if (index == -1) {
                    return null;
                }
                PsiStatement assignment = (PsiStatement)firstIterationStatements.remove(index);
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignment, PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return null;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiAssignmentExpression.class);
                if (assignmentExpression == null) {
                    return null;
                }
                PsiStatement otherBlock = firstIterationThen ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
                List otherIterationStatements = SpecialFirstIterationLoop.unwrapBlock(otherBlock);
                return firstIterationThen ? new ConditionData(firstIterationStatements, otherIterationStatements, assignmentExpression) : new ConditionData(otherIterationStatements, firstIterationStatements, assignmentExpression);
            }
        }
    }
}

