/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private final LocalQuickFix myQuickFixAction = new AcceptSuggested();
    @NonNls
    private static final String SHORT_NAME = "RedundantCast";
    public boolean IGNORE_SUSPICIOUS_METHOD_CALLS;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return RedundantCastUtil.createRedundantCastVisitor((Processor<? super PsiTypeCastExpression>)((Processor)typeCast -> {
            ProblemDescriptor descriptor = this.createDescription((PsiTypeCastExpression)typeCast, holder.getManager(), isOnTheFly);
            if (descriptor != null) {
                holder.registerProblem(descriptor);
            }
            return true;
        }));
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JavaAnalysisBundle.message((String)"ignore.casts.in.suspicious.collections.method.calls", (Object[])new Object[0]), "IGNORE_SUSPICIOUS_METHOD_CALLS");
        return optionsPanel;
    }

    @Nullable
    private ProblemDescriptor createDescription(@NotNull PsiTypeCastExpression cast, @NotNull InspectionManager manager, boolean onTheFly) {
        String message2;
        PsiElement gParent;
        PsiExpression operand2 = cast.getOperand();
        PsiTypeElement castType = cast.getCastType();
        if (operand2 == null || castType == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getParent());
        if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && this.IGNORE_SUSPICIOUS_METHOD_CALLS && (message2 = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiMethodCallExpression)gParent, operand2, operand2.getType(), true, new ArrayList<SuspiciousMethodCallUtil.PatternMethod>(), 0)) != null) {
            return null;
        }
        String message3 = JavaAnalysisBundle.message((String)"inspection.redundant.cast.problem.descriptor", (Object[])new Object[]{"<code>" + PsiExpressionTrimRenderer.render((PsiExpression)operand2) + "</code>", "<code>#ref</code> #loc"});
        return manager.createProblemDescriptor((PsiElement)castType, message3, this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly);
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private AcceptSuggested() {
        }

        @NotNull
        public String getFamilyName() {
            return JavaAnalysisBundle.message((String)"inspection.redundant.cast.remove.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTypeCastExpression cast;
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression psiTypeCastExpression = cast = castTypeElement == null ? null : (PsiTypeCastExpression)castTypeElement.getParent();
            if (cast != null) {
                RemoveRedundantCastUtil.removeCast(cast);
            }
        }
    }
}

