/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SourceOperation
implements Operation {
    final PsiType myType;
    final String mySourceName;

    @Contract(pure=true)
    SourceOperation(@NotNull PsiType type2, @Nullable String sourceName) {
        this.myType = type2;
        this.mySourceName = sourceName;
    }

    @Nullable
    static SourceOperation create(@NotNull String name2, @NotNull PsiType type2, PsiExpression @NotNull [] args) {
        if ("empty".equals(name2) && args.length == 0) {
            return new Empty(type2);
        }
        if ("of".equals(name2) && args.length == 1) {
            return new Of(type2, args[0]);
        }
        if ("ofNullable".equals(name2) && args.length == 1) {
            return new OfNullable(type2, args[0]);
        }
        return null;
    }

    @Override
    @NotNull
    public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
        return this.mySourceName == null ? new ChainVariable(this.myType) : new ChainVariable(this.myType, this.mySourceName);
    }

    @Nullable
    private static String getSourceName(@NotNull PsiExpression source) {
        PsiReference reference = (PsiReference)ObjectUtils.tryCast((Object)source, PsiReference.class);
        if (reference == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
        return variable == null ? null : variable.getName();
    }

    static class Empty
    extends SourceOperation {
        Empty(PsiType type2) {
            super(type2, null);
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            outVar.addBestNameCandidate("empty");
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            return outVar.getDeclaration("null") + context.generateNotNullCondition(outVar.getName(), code);
        }
    }

    static class OfNullable
    extends SourceOperation {
        private PsiExpression myArg;

        @Contract(pure=true)
        OfNullable(PsiType type2, PsiExpression arg) {
            super(type2, SourceOperation.getSourceName(arg));
            this.myArg = arg;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull ChainVariable newVar, @NotNull OptionalToIfContext context) {
            this.myArg = FunctionHelper.replaceVarReference(this.myArg, oldName, newVar.getName(), context);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (SourceOperation.getSourceName(this.myArg) != null || this.myArg.getText().equals(outVar.getName())) {
                return context.generateNotNullCondition(outVar.getName(), code);
            }
            return outVar.getDeclaration(this.myArg.getText()) + context.generateNotNullCondition(outVar.getName(), code);
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (SourceOperation.getSourceName(this.myArg) == null) {
                FunctionHelper.suggestFromExpression(outVar, context.getProject(), this.myArg);
            }
        }
    }

    static class Of
    extends SourceOperation {
        private PsiExpression myArg;

        @Contract(pure=true)
        Of(@NotNull PsiType type2, @NotNull PsiExpression arg) {
            super(type2, SourceOperation.getSourceName(arg));
            this.myArg = arg;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull ChainVariable newVar, @NotNull OptionalToIfContext context) {
            this.myArg = FunctionHelper.replaceVarReference(this.myArg, oldName, newVar.getName(), context);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (SourceOperation.getSourceName(this.myArg) != null || this.myArg.getText().equals(outVar.getName())) {
                return "if(" + outVar.getName() + "==null)throw new java.lang.NullPointerException();" + code;
            }
            return outVar.getDeclaration(this.myArg.getText()) + "if(" + outVar.getName() + "==null)throw new java.lang.NullPointerException();" + code;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            if (SourceOperation.getSourceName(this.myArg) == null) {
                FunctionHelper.suggestFromExpression(outVar, context.getProject(), this.myArg);
            }
        }
    }
}

