/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionalToIfContext
extends ChainContext {
    private static final Logger LOG = Logger.getInstance(OptionalToIfContext.class);
    private final ChainExpressionModel myModel;
    private String myInitializer;
    private String myElseBranch;
    private List<String> myLambdaNames = new ArrayList<String>();

    OptionalToIfContext(@NotNull PsiExpression chainExpression, @NotNull ChainExpressionModel model) {
        super((PsiElement)chainExpression);
        this.myModel = model;
    }

    @NotNull
    String addInitializer(@NotNull String code) {
        code = this.drainBeforeSteps() + code + this.drainAfterSteps();
        if (this.myInitializer == null) {
            return code;
        }
        return this.myModel.addInitializer(this.myModel.createInitializer(this.myInitializer), code);
    }

    @NotNull
    String createResult(@NotNull String expression2) {
        return this.myInitializer == null ? this.myModel.createInitializer(expression2) : this.myModel.createResult(expression2);
    }

    void setInitializer(@NotNull String initializer) {
        LOG.assertTrue(this.myInitializer == null);
        if (this.myModel.needsAdditionalVariable()) {
            String additionalVarName = this.registerVarName(Arrays.asList("result", "nonFinalResult", "nonFinal"));
            this.myModel.setVarName(additionalVarName);
        }
        this.myInitializer = initializer;
    }

    void setElseBranch(String elseBranch) {
        this.myElseBranch = elseBranch;
    }

    String getElseBranch() {
        return this.myElseBranch;
    }

    @NotNull
    String generateNotNullCondition(@NotNull String arg, @NotNull String code) {
        if (this.myElseBranch == null) {
            return "if(" + arg + "!=null){\n" + code + "\n}";
        }
        return "if(" + arg + "==null)" + this.myElseBranch + code;
    }

    @Nullable
    String generateCondition(@NotNull PsiExpression conditional, @NotNull String code) {
        if (this.myElseBranch == null) {
            return "if(" + conditional.getText() + "){\n" + code + "\n}";
        }
        String negated = BoolUtils.getNegatedExpressionText(conditional, new CommentTracker());
        return "if(" + negated + ")" + this.myElseBranch + code;
    }

    boolean isUsedLambdaVarName(String name2) {
        return this.myLambdaNames.contains(name2);
    }

    void addLambdaVarName(@NotNull String name2) {
        this.myLambdaNames.add(name2);
    }

    @Nullable
    static OptionalToIfContext create(@NotNull PsiExpression chainExpression) {
        PsiStatement chainStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)chainExpression, PsiStatement.class);
        if (chainStatement == null) {
            return null;
        }
        ChainExpressionModel model = ChainExpressionModel.create(chainStatement, chainExpression);
        if (model == null) {
            return null;
        }
        return new OptionalToIfContext(chainExpression, model);
    }

    private static class ChainDeclaration
    extends ChainExpressionModel {
        private final PsiLocalVariable myVariable;
        private String myName;

        ChainDeclaration(@Nullable String name2, @NotNull PsiLocalVariable variable) {
            this.myName = name2;
            this.myVariable = variable;
        }

        @Override
        boolean needsAdditionalVariable() {
            return !this.myVariable.getName().equals(this.myName);
        }

        @Override
        public void setVarName(@NotNull String name2) {
            this.myName = name2;
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            LOG.assertTrue(this.myName != null);
            return this.myName + "=" + expression2 + ";";
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            if (this.myName == null || !this.needsAdditionalVariable()) {
                return this.declareVariable(expression2);
            }
            String typeText = this.myVariable.getType().getCanonicalText();
            return typeText + " " + this.myName + "=" + expression2 + ";";
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            return this.needsAdditionalVariable() ? initializer + code + this.declareVariable(this.myName) : initializer + code;
        }

        private String declareVariable(@NotNull String expression2) {
            PsiModifierList modifierList;
            PsiLocalVariable copy = (PsiLocalVariable)this.myVariable.copy();
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)this.myVariable.getProject());
            copy.setInitializer(factory.createExpressionFromText(expression2, (PsiElement)this.myVariable));
            if (!this.needsAdditionalVariable() && (modifierList = copy.getModifierList()) != null) {
                modifierList.setModifierProperty("final", false);
            }
            return copy.getText();
        }

        @Nullable
        static ChainDeclaration create(@NotNull PsiDeclarationStatement declaration2, @NotNull PsiExpression chainExpression) {
            PsiElement[] elements = declaration2.getDeclaredElements();
            if (elements.length != 1) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
            if (variable == null || PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()) != chainExpression) {
                return null;
            }
            boolean needsAdditionalVariable = !VariableAccessUtils.canUseAsNonFinal(variable);
            String name2 = needsAdditionalVariable ? null : variable.getName();
            return new ChainDeclaration(name2, variable);
        }
    }

    private static class ChainAssignment
    extends ChainExpressionModel {
        private final String myName;

        private ChainAssignment(@NotNull String name2) {
            this.myName = name2;
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            return this.myName + "=" + expression2 + ";";
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            return this.createResult(expression2);
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            return initializer + code;
        }

        @Nullable
        static ChainExpressionModel create(@NotNull PsiAssignmentExpression assignment, @NotNull PsiExpression chainExpression) {
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()) != chainExpression) {
                return null;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (ref == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (variable == null || variable.hasModifierProperty("final")) {
                return null;
            }
            String name2 = variable.getName();
            return name2 == null ? null : new ChainAssignment(name2);
        }
    }

    private static class ChainReturn
    extends ChainExpressionModel {
        private final PsiReturnStatement myChainReturnCopy;
        private PsiExpression myChainExpressionCopy;

        private ChainReturn(@NotNull PsiReturnStatement chainReturnCopy, @NotNull PsiExpression chainExpressionCopy) {
            this.myChainReturnCopy = chainReturnCopy;
            this.myChainExpressionCopy = chainExpressionCopy;
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myChainExpressionCopy.getProject()).getElementFactory();
            PsiExpression newExpression = factory.createExpressionFromText(expression2, (PsiElement)this.myChainExpressionCopy);
            this.myChainExpressionCopy = (PsiExpression)this.myChainExpressionCopy.replace((PsiElement)newExpression);
            return this.myChainReturnCopy.getText();
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            return this.createResult(expression2);
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            return code + initializer;
        }

        @Nullable
        private static ChainReturn create(@NotNull PsiReturnStatement chainReturn, @NotNull PsiExpression chainExpression) {
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)chainReturn.getReturnValue()) != chainExpression) {
                return null;
            }
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)chainExpression, (Object)mark);
            PsiReturnStatement chainReturnCopy = (PsiReturnStatement)ObjectUtils.tryCast((Object)chainReturn.copy(), PsiReturnStatement.class);
            if (chainReturnCopy == null) {
                return null;
            }
            PsiExpression chainExpressionCopy = (PsiExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.releaseMark((PsiElement)chainReturnCopy, (Object)mark), PsiExpression.class);
            if (chainExpressionCopy == null) {
                return null;
            }
            return new ChainReturn(chainReturnCopy, chainExpressionCopy);
        }
    }

    private static class ChainStatement
    extends ChainExpressionModel {
        private ChainStatement() {
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            return "";
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            return "";
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            return code;
        }
    }

    private static abstract class ChainExpressionModel {
        private ChainExpressionModel() {
        }

        @NotNull
        abstract String createResult(@NotNull String var1);

        @NotNull
        abstract String createInitializer(@NotNull String var1);

        @NotNull
        abstract String addInitializer(@NotNull String var1, @NotNull String var2);

        boolean needsAdditionalVariable() {
            return false;
        }

        public void setVarName(@NotNull String name2) {
        }

        @Nullable
        static ChainExpressionModel create(@NotNull PsiStatement chainStatement, @NotNull PsiExpression chainExpression) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)chainStatement, PsiReturnStatement.class);
            if (returnStatement != null) {
                return ChainReturn.create(returnStatement, chainExpression);
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)chainStatement);
            if (assignment != null) {
                return ChainAssignment.create(assignment, chainExpression);
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)chainStatement, PsiDeclarationStatement.class);
            if (declaration2 != null) {
                return ChainDeclaration.create(declaration2, chainExpression);
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)chainStatement, PsiExpressionStatement.class);
            if (expressionStatement != null && PsiUtil.skipParenthesizedExprDown((PsiExpression)expressionStatement.getExpression()) == chainExpression) {
                return new ChainStatement();
            }
            return null;
        }
    }
}

