/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.lambdaToExplicit.LambdaAndExplicitMethodPair;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExcessiveLambdaUsageInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiElement parent = lambda2.getParent();
                if (!(parent instanceof PsiExpressionList)) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                if (call == null) {
                    return;
                }
                if (!(lambda2.getBody() instanceof PsiExpression)) {
                    return;
                }
                PsiExpression expr2 = (PsiExpression)lambda2.getBody();
                if (!ExpressionUtils.isSafelyRecomputableExpression(expr2)) {
                    return;
                }
                if (Stream.of(lambda2.getParameterList().getParameters()).anyMatch(param -> ExpressionUtils.isReferenceTo(expr2, (PsiVariable)param))) {
                    return;
                }
                for (LambdaAndExplicitMethodPair info : LambdaAndExplicitMethodPair.INFOS) {
                    if (!info.isLambdaCall(call, lambda2)) continue;
                    holder.registerProblem((PsiElement)lambda2, JavaBundle.message((String)"inspection.excessive.lambda.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(0, expr2.getStartOffsetInParent()), new LocalQuickFix[]{new RemoveExcessiveLambdaFix(info, info.getExplicitMethodName(call))});
                }
            }
        };
    }

    static class RemoveExcessiveLambdaFix
    implements LocalQuickFix {
        private final LambdaAndExplicitMethodPair myInfo;
        private final String myName;

        RemoveExcessiveLambdaFix(LambdaAndExplicitMethodPair info, String name2) {
            this.myInfo = info;
            this.myName = name2;
        }

        @Nls
        @NotNull
        public String getName() {
            return JavaBundle.message((String)"inspection.excessive.lambda.fix.name", (Object[])new Object[]{this.myName});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.excessive.lambda.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            ExpressionUtils.bindCallTo(call, this.myInfo.getExplicitMethodName(call));
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)lambda2, ct.text(body2));
        }
    }
}

